----- Listing 4: The functions <f>_vec_new<d> and <f>_vec_delete<d> ---

typedef unsigned char BYTE;          // useful typedef
typedef void* (* ctorp)(BYTE *);     // pointer to a constructor fn
typedef void (* dtorp)(BYTE *, int); // pointer to a destructor fn

void* _vec_new(void* p,       // if not NULL, memory has already been
                              // allocated at this address for the
                              // vector and will not be _new-ed
               int   numelem, // number of elements to be created
               int   size,    // size of an element
               ctorp pctor    // pointer to contstructor function
              )
// Creates a vector of objects, calling the constructor for each.
{
  int i;
  BYTE* pobj;
  if (!p)
    p = _new(numelem*size);
  for(i = 1, pobj = (BYTE *)p; i <= numelem; i++, pobj += size)
    (*pctor)(pobj); // call the constructor
  return (void*)p;
}

void _vec_delete(void* p,       // pointer to vector to be deleted
                 int   numelem, // number of elements to be deleted
                 int   size,    // size of each element
                 dtorp pdtor,   // pointer to destructor function
                 int   free     // !=0 true if the memory at p is to be
                                // _deleted, 0 otherwise
                )
// Deletes a vector of objects, calling the destructor for each.
{
  int i;
  BYTE* pobj;
  pobj = (BYTE *)p;
  for(i = 1, pobj = (BYTE *)p; i <= numelem; i++, pobj+=size)
    (*pdtor)(pobj, 0); // call the destructor
                       // 0 => don't call _delete for the element
                       // (see typical destructor function)
  if (free)
    _delete(p);
}

