/***************************************************

  FILE NAME   : cline.cpp
  AUTHOR      : Matt Weisfeld                     
                                                  
  DESCRIPTION : building a command line

***************************************************/
#include <iostream.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "cline.hpp"

//  DESCRIPTION  : default constructor
command_line::command_line() {
	command_buffer = new char [1];
	if (command_buffer == NULL) {
		cout << "Error: nospace" << endl;
		exit(0);
	}
	command_buffer[0] = '\0';
	Cargc = 0;
	Cargv = new char * [1];
	Cargv[0] = NULL;
}
//  DESCRIPTION  : initialization constructor
command_line::command_line(const char *command_string) {
	command_buffer = new char [1];
	if (command_buffer == NULL) {
		cout << "Error: nospace" << endl;
		exit(0);
	}
	Cargc = 0;
	Cargv = new char * [1];
	Cargv[0] = NULL;
	build_command(command_string);
}
//  DESCRIPTION  : copy constructor
command_line::command_line(const command_line& ccommand_line) {
	command_buffer = new char [1];
	if (command_buffer == NULL) {
		cout << "Error: nospace" << endl;
		exit(0);
	}
	Cargc = 0;
	Cargv = new char * [1];
	Cargv[0] = NULL;
	build_command(ccommand_line.command_buffer);
}
//  DESCRIPTION  : destructor
command_line::~command_line() {
	delete [] command_buffer;
	for (int i = 0; Cargv[i] != '\0'; i++) {
		delete [] Cargv[i];
	}
	delete [] Cargv;

}
//  DESCRIPTION  : assignment operator for class
command_line& command_line::operator=(const command_line& ccommand_line)
{
	strcpy (command_buffer, ccommand_line.command_buffer);
	for (int i = 0; i != Cargc; i++) {
		delete [] Cargv[i];
	}
	delete [] Cargv;
	build_command(command_buffer);
	return *this;
}
//  DESCRIPTION  : assignment operator for char *
command_line& command_line::operator=(const char *command_string)
{
	strcpy (command_buffer, command_string);
	for (int i = 0; i != Cargc; i++) {
		delete [] Cargv[i];
	}
	delete [] Cargv;
	build_command(command_buffer);

	return *this;
}
//  DESCRIPTION  : print the Cargv information
void command_line::print() {
	cout << "******* start print *******" << endl;
	cout << "Cargc = " << Cargc << endl;
	cout << "command_buffer = " << command_buffer << endl;
	for (int i = 0; Cargv[i] != NULL; i++) {
		cout << "Cargv[" << i << "] = " << Cargv[i] << endl;
	}
	cout << "******** end print ********" << endl;
}
//  DESCRIPTION  : convert a char * to a char **
//		   (Cargv-like structure)
void command_line::build_command(const char *command_string){
	int index = 0, pos=0;
	char buffer[200];

	// delete old memory and get some new memory for command_buffer

	delete [] command_buffer;
	command_buffer =  new char [strlen(command_string)+1];
	if (command_buffer == NULL) {
		cout << "Error: nospace" << endl;
		exit(0);
	}
	strcpy (command_buffer, command_string);

	// get the number of tokens
	strtokens(command_string);

	// delete the space for the old command_line

	for (int i = 0; Cargv[i] != '\0'; i++) {
		delete [] Cargv[i];
	}
	delete [] Cargv;

	/* get space for the new command line */

	Cargv = (char **) new char * [Cargc+1];
	if (Cargv == NULL) {
		cout << "Error: no space" << endl;
		exit(0);
	}

	// flush the white space

	while ( isspace(*command_string) )
		command_string++;

	index = 0;

	// start the loop to build all the individual tokens

	while (*command_string != '\0') {

		pos = 0;

		// copy the token until white space is found

		while ( !isspace(*command_string) && *command_string != '\0') {

			buffer[pos++] = *command_string++;

		}

		buffer[pos] = '\0';

		// get space for the individual tokens

		Cargv[index] = (char *) new char [strlen(buffer)+1];
		if (Cargv[index] == NULL) {
			cout << "Error: nospace" << endl;
			exit(0);
		}

		// copy the token

		strcpy (Cargv[index++], buffer);

		// flush while space

		while ( isspace(*command_string) )
			command_string++;

	}

	// finish by setting the las pointer to NULL
	Cargv[Cargc] = NULL;
}
//  DESCRIPTION  : determine the number of tokens in the char *
void command_line::strtokens(const char *command_string)
{
	int count = 0;
	const char *temp;

	temp = command_string;

	/* bypass white space */

	while (isspace(*temp)) temp++;

	for (count=0; *temp != '\0'; count++) {

		/* continue until white space of string terminator is found */

		while ((!isspace(*temp)) && (*temp != '\0')) temp++;

		/* bypass white space */

		while (isspace(*temp)) temp++;
		
	}
	Cargc = count;
}
