/***************************************************

  FILE NAME   : cline.hpp
  AUTHOR      : Matt Weisfeld                     
                                                  
  DESCRIPTION : building a command line

***************************************************/
#ifndef CLINE_HPP
#define CLINE_HPP

#include <iostream.h>

class command_line {
friend class child_process;
private:
	char *command_buffer;
	char **Cargv;
public:
	int Cargc;
	// default constructor
	command_line();
	// initialization constructor
	command_line(const char *);
	// copy constructor
	command_line(const command_line&);
	// destructor
	virtual ~command_line();
	// assignment operator for class
	command_line& operator=(const command_line&);
	// assignment operator for char *
	command_line& operator=(const char *);
	// convert a char * to a char ** (argv-like structure)
	void build_command(const char *);
	// convert a char * to a char ** (argv-like structure)
	char **return_command(void);
	// determine the number of token in a char *
	void strtokens(const char *);
	// print contents of the argv object
	void print();
};
#endif
