/***************************************************

  FILE NAME   : cproc.cpp
  AUTHOR      : Matt Weisfeld                     
						  
  DESCRIPTION : execute child processes

***************************************************/
#include <iostream.h>
#include <string.h>
#include "cproc.hpp"
#ifdef DOS
#include <process.h>    // for _SPAWN 
#include <stdlib.h>
#endif

// DESCRIPTION  : default constructor
child_process::child_process() {
	CLINE = new command_line;
	command_extension[0] = NULL;
}
// DESCRIPTION  : character initialization constructor
child_process::child_process(const char *command) {
	CLINE = new command_line (command);
	command_extension[0] = NULL;
}
// DESCRIPTION  : child process object copy constructor
child_process::child_process(const child_process& cchild_process) {
	CLINE = new command_line (cchild_process.CLINE->command_buffer);
	strcpy(command_extension, cchild_process.command_extension);
}
// DESCRIPTION  : destructor
child_process::~child_process() {
	delete CLINE;
}
// DESCRIPTION  : build the calling path & execute
int child_process::exec_function(void) {
	int child_status;

	add_extension();

	if ((child_status = spawnv(P_WAIT,command_extension,CLINE->Cargv)) == -1) {
			return (-1);
	}

	cout << "CHILD STATUS = " << child_status << endl;

	return (child_status);
}
// DESCRIPTION  : add the file extension to the program name
void child_process::add_extension(void) {
	char command_buffer[100];
	char *command_ptr;
	char path[100];
	char program[100];
	char args[100];

	strcpy (path, PATH);

	strcpy (command_buffer, CLINE->command_buffer);

	command_ptr = command_buffer;

	for (int i=0; *command_ptr!=' '; i++, command_ptr++) {
		program[i] = *command_ptr;
	}
	program[i]='\0';

	strcpy (args, command_ptr);

	strcpy (command_extension, path);

	strcat (command_extension, program);
	strcat (command_extension, ".exe");
	strcat (command_extension, args);
}
// DESCRIPTION  : assignment operator for CCargv list
child_process& child_process::operator=(const char *ptr) {
	CLINE->build_command(ptr);
	return *this;
}
// DESCRIPTION  : assignment operator for argv list
child_process& child_process::operator=(const child_process& func) {
	CLINE->build_command(func.CLINE->command_buffer);
	return *this;
}
// DESCRIPTION  : execute the commmand as a child process via exec_function()
child_process::operator const int () {
	int status;

	status = exec_function();

	return(status);
}
