/***************************************************

  FILE NAME   : cproc.hpp
  AUTHOR      : Matt Weisfeld                     
                                                  
  DESCRIPTION : execute child processes

***************************************************/
#ifndef CPROC_HPP
#define CPROC_HPP

#include "cline.hpp"

#define PATH "c:\\exe\\" 	// for DOS only
#define STRLEN 100

class child_process {
private:
	command_line *CLINE;
	char command_extension[STRLEN];
public:
	// default constructor
	child_process();
	// initialization constructor
	child_process(const char *);
	// copy constructor
	child_process(const child_process& cchild_process);
	// destructor
	~child_process();
	// character assignment operator
	child_process& operator=(const char *ptr);
	// child_process object assignment operator
	child_process& operator=(const child_process&);
	// call the child process via exec_function()
	operator const int ();
	// add the file extension suffix
	void add_extension(void);
	// build the calling path and execute
	int exec_function(void);
};
#endif
