/* MEMMAX.C: This program uses 
 * _memmax and _nmalloc to allocate
 * the largest block of memory 
 * available in the near heap.
 */
#include <stddef.h>
#include <malloc.h>
#include <stdio.h>
void main( void )
{
   size_t contig;
   char *p;

   /* Determine contiguous 
      memory size */

   contig = _memmax();
   printf("Largest block of 
          available memory is %u 
          bytes long\n", 
          contig  );
   if( contig )
   {
      p = _nmalloc(
               contig*sizeof(int));
      if( p == NULL )
         printf("Error with malloc 
                (should never 
                 occur)\n" );
      else
      {
         printf("Maximum allocation 
                succeeded\n" );
         free( p );
      }
   }
   else
      printf( "Near heap is already 
               full\n" );
}
/* end of MEMMAX.C */

