#define SECOND          long
#define MILLISECOND     long
#define kHistoryEntries 10
#define kInitialWait    30

class TCountDownClock
{
public: // public member functions
 TCountDownClock(long lBytesToTransfer);
 SECOND TimeRemaining(long lBytesTransfered);
 void Start(void);
protected: // protected member functions
 void  StoreTransferRate(float fTransferRate);
 float CalculateTransferRate(float fOverallAvg);
 float WeighRecentRates(void);
protected: // protected data members
 long m_lIntervalCount;
 MILLISECOND m_msStartTime;
 MILLISECOND m_msLastTime;
 long m_lBytesToTransfer; 
 long m_lLastBytes;
 int m_nRatesStored;
 float m_fTransRateHistory[kHistoryEntries];
};

// ---------------------------------------

void  TCountDownClock::StoreTransferRate(float fTransferRate)
{
    int i;
 
    for (i = 0; i < kHistoryEntries - 1; i++)
    {
        m_fTransRateHistory[i] = m_fTransRateHistory[i + 1];
    }
    m_fTransRateHistory[kHistoryEntries - 1] = fTransferRate;

    if (m_nRatesStored < kHistoryEntries)
    {
        m_nRatesStored++;
    }
}

// ---------------------------------------

TCountDownClock::TCountDownClock(long lBytesToTransfer)
{
    int i;

    m_lBytesToTransfer = lBytesToTransfer;    
    m_nRatesStored = 0;
    m_lLastBytes = 0L;
    m_lIntervalCount = 0L;

    for (i = 0; i < kHistoryEntries; i++)
    {
        m_fTransRateHistory[i] = -1.0;
    }
}

// ---------------------------------------

TCountDownClock::Start()
{
  m_msStartTime = (MILLISECOND)SystemTime();
  m_msLastTime = m_msStartTime;
}

// ---------------------------------------

float TCountDownClock::WeighRecentRates(void)
{
  float fSum = fWeightSum = 0.0; int i;
  for (i = 0; i < kHistoryEntries; i++)
  {
    fSum += i * m_fTransRateHistory[i];
    fWeightSum += i;
  }
  return fSum / fWeightSum;
}

// ---------------------------------------

SECONDS TCountDownClock::TimeRemaining(long lBytesTransfered)
{
  MILLISECOND msCurrentTime, 
                      msTimeElapsed;
  float fBytesPerSecond, 
           fAvgBytesPerSecond, 
           fTransferRate;
  long  lBytesTransferedThisInterval;

  // Calculate and store the current interval transfer rate
  msCurrentTime = (MILLISECONDS)SystemTime();
  m_lIntervalCount++;
  msTimeElapsed = msCurrentTime - m_msLastTime;
  m_msLastTime = msCurrentTime;
  lBytesTransferedThisInterval = lBytesTransfered - m_lLastBytes;
  m_lLastBytes = lBytesTransferedThisInterval;
  fBytesPerSecond = float(lBytesTransferedThisInterval) /
                    (float(msTimeElapsed) * 1000.0);
  StoreTransferRate(fBytesPerSecond); 
  
  // convert from MILLISECOND to
  // SECOND and see if enough time
  // has elapsed to report a meaningful
  // result  
  if ((msCurrentTime - m_msStartTime) * 1000 < kInitialWait)
  {
	return -1; 
  }
    
  // Calculate the overall average
  // transfer rate
  fAvgBytesPerSecond = float(lBytesTransfered )/
		         (float(msCurrentTime - m_msStartTime) /1000.0);
  
  // calculate the weighted transfer rate
  fTransferRate = CalculateTransferRate(fAvgBytesPerSecond);
  
  // return the estimated time in SECONDs
  // for the data transfer to complete  	
  return SECONDS(float(m_lBytesToTransfer - lBytesTransfered) /
fTransferRate);
}

// ------------------------------------

float TCountDownClock::CalculateTransferRate(float fOverallAvg)
{
  long lAvgWeight;
  float fWeightedRecentAvg;

  // the weighting for the recent average
  // is always 3.  Calculate the weight for
  // the overall average
  lAvgWeight = m_lIntervalCount / kHistoryEntries;
  
  // compute the weighted average of recent 
  // transfer rates
  fWeightedRecentAvg = WeighRecentRates();
  
  // return the overall weighted average
  // transfer rate in bytes/second
  
  return (
         (fWeightedRecentAvg * 3 + 
         fOverallAvg * lAvgWeight) /
         (float)(3 + lAvgWeight)
         );
}

// ----------------------------------------------

MILLISECOND SystemTime(void)
{
    // System Specific
}

