// Listing 4: test2.cpp
#include <string.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include "qsortT.h"

// simple class to hold a word
class Word
{
public:
  Word(const char *val = 0)
  {
    if (val)
    {
      strncpy(buf, val, bufLen);
      buf[bufLen-1] = '\0';
    }
    else
      buf[0] = '\0';
  }
  // conversion to C string for printing
  operator const char *() const
  { return buf; }

  // comparison operators for sorting
  int operator==(const Word &word) const
  { return (strcmp(buf, word.buf) == 0); }
  int operator<(const Word &word) const
  { return (strcmp(buf, word.buf) < 0); }
private:
  enum { bufLen = 40 };
  char buf[bufLen];
};

int main()
{
  const int maxWords = 100;
  int nWords = 0;
  Word **wArry = new Word* [maxWords];
  char tmp[40];

  while (cin >> setw(sizeof(tmp)) >> tmp)
  {
    wArry[nWords++] = new Word(tmp);
    if (nWords >= maxWords)
      break;
  }

  // sort and print results
  qsortPT(wArry, nWords);
  for (int i = 0; i < nWords; i++)
  {
    cout << *(wArry[i]) << endl;
    delete wArry[i];
  }
  delete []wArry;
  return 0;
}
// End of Listing 4
