Listing 1 - The header that defines the scanner and token classes.

//
// scanner.h
//
// Copyright (C) 1996 by Dan Saks.
// May be copied for private, non-commercial use,
// provided this copyright notice remains intact.
// All other rights reserved.
//

#ifndef SCANNER_H_INCLUDED
#define SCANNER_H_INCLUDED

#include <iostream>
#include <limits.h>
#include <string>

class token
    {
    friend class scanner;
public:
    enum category
        {
        AMPERSAND = '&',
        COMMA = ',',
        LEFT_BRACKET = '[',
        LEFT_PAREN = '(',
        RIGHT_BRACKET = ']',
        RIGHT_PAREN = ')',
        SEMICOLON = ';',
        STAR = '*',
        NO_MORE = CHAR_MAX + 1,
        SCOPE,
        INT_LITERAL,
        IDENTIFIER,
        NAME,
        TYPE_KEYWORD,
        CONST,
        VOLATILE,
        NO_SUCH,
        NO_VALUE
        };
    token();
    string text() const;
    category kind() const;
private:
    token(category, const string &);
    category the_kind;
    string the_text;
    };

const char *image(token::category);

class scanner
    {
public:
    scanner(istream &);
    token current() const;
    token get();
    token unget();
private:
    token scan();
    token previous_token, current_token, next_token;
    istream &in_stream;
    struct pair
        {
        char const *text;
        token::category kind;
        };
    static pair const keyword[];
    scanner(const scanner &);
    scanner &operator=(const scanner &);
    };

//
// token inline functions
//
inline
token::token()
    : the_kind(NO_VALUE)
    {
    }

inline
token::token(category c, const string &s)
    : the_kind(c), the_text(s)
    {
    }

inline
string token::text() const
    {
    return the_text;
    }

inline
token::category token::kind() const
    {
    return the_kind;
    }

//
// scanner inline functions
//
inline
scanner::scanner(istream &s)
    : in_stream(s)
    {
    }

inline
token scanner::current() const
    {
    return current_token;
    }

#endif

