#include <iostream.h>

class boolean
    {
public:
    boolean(int = 0);
    operator void *() const;
private:
    boolean(char);
    boolean(signed char);
    boolean(unsigned char);
    boolean(short);
    boolean(unsigned short);
    boolean(unsigned int);
    boolean(long);
    boolean(unsigned long);
    boolean(float);
    boolean(double);
    boolean(long double);
    char value_;
};

inline boolean::boolean(int value) :
        value_(value ? (char) 1 : 0)
    {
    }

inline boolean::operator void *() const
    {
    static char dummy;
    return value_ ? &dummy : 0;
    }

inline ostream &operator<<
        (ostream &left, boolean const &right)
    {
    return left << (right ? "TRUE" : "FALSE");
    }

boolean const FALSE(0);
boolean const TRUE(1);
