/* protocol.h: */
#include <stdio.h>

#define MSG_LEN 80

#define NOP_OPCODE       0
#define PRINT_OPCODE     1
#define TERMINATE_OPCODE 2

typedef struct {
  int    opcode;
  char   message[MSG_LEN];
  int    result;
} Protocol_td;

/* server.c: */

#include <stdio.h>
#include <string.h> 
#include <stdlib.h> 

#include "shm_pack.h" 
#include "protocol.h"

int process(Protocol_td *pProtocolBlock, SMEM *smd)
{
  int nchars_printed; 

  switch(pProtocolBlock->opcode)
  {
    case PRINT_OPCODE : 
      if (pProtocolBlock->message[0] != '\n')  
        nchars_printed = printf("Received: <%s>\n",pProtocolBlock->message); 
      else
        nchars_printed = printf("Received: Hello World!\n"); 
      break;
    case TERMINATE_OPCODE : 
    default: 
      nchars_printed = -1; 
      break;
   }

  return nchars_printed;
}

void server(int key)
{
  Protocol_td ProtocolBlock; 
  SMEM *smd;
  int  result = 0; 

  memset(&ProtocolBlock, '\0', sizeof(Protocol_td)); 
  smd = shm_open(key, "w"); 
  shm_write(&ProtocolBlock, sizeof(Protocol_td), 1, smd); 
  shm_close(smd); 

  smd = shm_open(key,"rp+"); 
  while (-1 != result)
  {
    shm_rewind(smd); 
    shm_read(&ProtocolBlock, sizeof(Protocol_td), 1, smd); 

    if (ProtocolBlock.opcode) 
    {      
      result = process(&ProtocolBlock, smd);  
      ProtocolBlock.result = result; 
      ProtocolBlock.opcode = 0; 
      shm_rewind(smd); 
      shm_write(&ProtocolBlock, sizeof(Protocol_td), 1, smd);
    }
  }   
  shm_close(smd); 
}

void main(int argc, char *argv[]) 
{
  char *ptr; 
  int  key; 

  if ((argc != 2) || (strncmp(argv[1],"-key=",5) != 0))
  {
    printf("Synopsis: %s -key=<n> &\n",argv[0]); 
    exit(0); 
  }

  ptr = strchr(argv[1],'='); 
  key = atoi(&ptr[1]); 

  server(key);   
  sleep(1); 
  shm_delete(key); 
}

/* client.c: */

#include <stdio.h>
#include <string.h> 
#include <stdlib.h> 

#include "shm_pack.h" 
#include "protocol.h"

void client(int key)
{
  Protocol_td ProtocolBlock; 
  SMEM *smd;

  ProtocolBlock.opcode = NOP_OPCODE; 
  smd = shm_open(key, "rp+"); 
  if (!smd) 
  {
     printf("Cannot connect to key %d\n", key); 
     exit(0); 
  }

  printf("Enter a message and press ENTER\n"); 
  printf("Enter a single dot '.' and press ENTER to terminate\n"); 

  while (TERMINATE_OPCODE != ProtocolBlock.opcode)
  {
    char message[MSG_LEN]; 

    fgets(message, MSG_LEN, stdin); 

    if ('.' == message[0])
      ProtocolBlock.opcode = TERMINATE_OPCODE;
    else
    {
      ProtocolBlock.opcode = PRINT_OPCODE; 
      strncpy(ProtocolBlock.message, message, MSG_LEN); 
    }
   
    shm_rewind(smd); 
    shm_write(&ProtocolBlock, sizeof(Protocol_td), 1, smd); 
  }
  shm_close(smd); 
}

void main(int argc, char *argv[]) 
{
  char *ptr; 
  int  key; 

  if ((argc != 2) || (strncmp(argv[1],"-key=",5) != 0))
  {
    printf("Synopsis: %s -key=<n> &\n",argv[0]); 
    exit(0); 
  }

  ptr = strchr(argv[1],'='); 
  key = atoi(&ptr[1]); 

  client(key);   
}

