|                                                                       |
| Listing 2   Header file for madsub/matmpy options and prototypes      |
|                                                                       |
|                                                                       |
/* ============ */
/* matdefs.h    */
/* ============ */
/* ==================================================================== */
/*      D E F I N I T I O N S  F O R  M A T R I X  O P T I O N S        */
/* ==================================================================== */
# if defined(__MATDEFS_H)
#       /* do nothing */
# else
#       define __MATDEFS_H
/* -------------------------- */
/* MATRIX COMBINATION OPTIONS */
/* -------------------------- */
#define AB      0               /* A & B   */
#define ATB     1               /* A' & B  */
#define ABT     2               /* A & B'  */
#define ATBT    3               /* A' & B' */

/* -------------- */
/* RESULT OPTIONS */
/* -------------- */            /* MATMPY */
#define P       0               /* C =  Product */
#define MP      -2              /* C = -Product */
#define CPP     1               /* C += Product */
#define CMP     -1              /* C -= Product */
                                /* MADSUB */
#define APB     0               /* C =   A + B  */
#define AMB     1               /* C =   A - B  */
#define MAMB    2               /* C = -(A + B) */

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#       define  F( P )  P
# else
#       define  F( P )  ()
# endif

/* INDENT OFF */
extern  void    madsub F((double *, int, int, double *, int, int,
                        double *, int, int, int, int));
extern  void    matmpy F((double *, int, int, double *, int, int,
                        double *, int, int));
# undef F
/* INDENT ON */
# endif                                 /* __MATDEFS_H */
/* << matdefs.h >> */
