/* ============ */
/* tstmadsb.c	*/
/* ============ */
/* ==================================================================== */
/* T E S T S  M A T R I X  A D D - S U B T R A C T  S U B R O U T I N E */
/* ==================================================================== */
#include "matdefs.h"
#include <stdio.h>
/* INDENT OFF */
double ChkMat_AtPB[] =
    {
	2,	3,	4,	5,
	3,	4,	5,	6,
	4,	5,	6,	7,
	5,	6,	7,	8,
	6,	7,	8,	9,
	7,	8,	9,	10
    };
double ChkMat_APBt[] =
    {
	2,	3,	4,	5,	6,	7,
	3,	4,	5,	6,	7,	8,
	4,	5,	6,	7,	8,	9,
	5,	6,	7,	8,	9,	10
    };
double ChkMat_APB[] =
    {
	2,	4,	6,	8,	6,	8,
	4,	6,	4,	6,	8,	10,
	2,	4,	6,	8,	6,	8,
	4,	6,	4,	6,	8,	10
    };
double ChkMat_AMA[] =
    {
	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0
    };
double ChkMat_AtMAt[] =
    {
	0,	0,	0,	0,
	0,	0,	0,	0,
	0,	0,	0,	0,
	0,	0,	0,	0,
	0,	0,	0,	0,
	0,	0,	0,	0
    };
double	ChkMat_MAMB[] =
    {
        -2,	-4,	-6,	-8,	-6,	 -8,
        -4,	-6,	-4,	-6,	-8,	-10,
        -2,	-4,	-6,	-8,	-6,	 -8,
        -4,	-6,	-4,	-6,	-8,	-10
    };
/* ==================================================================== */
/* Chk2MatEq - Checks Two Matrices for Equality 			*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
void
Chk2MatEq(int n, double *A, double *B)
# else
void
Chk2MatEq(n, A, B)
int	n;
double *A;
double *B;
# endif
/* INDENT ON */
{
    int     k;

    for (k = 0; k < n; ++k)
    {
	if (A[k] == B[k])
	{
	    continue;
	}
	break;
    }

    fprintf(stderr, "Equality of Result and Test Matrices%s Verified\n",
	(k == n) ? "" : "NOT ");
    fflush(NULL);
}

/* ==================================================== */
/* imatprt - prints i x j matrix a on unit with title	*/
/* ==================================================== */
/* INDENT OFF */
# if defined(__STDC__) || defined(__PROTO__)
void
imatprt(double *a, int i, int j, FILE * unit, char *title)
# else
void
imatprt(a, i, j, unit, title)
double *a;
int	i;
int	j;
FILE   *unit;
char   *title;
# endif
/* INDENT ON */
{
    int     k, m;

    fprintf(unit, "%s\n", title);

    for (k = 0; k < i; k++)
    {
	fprintf(unit, "%9.0f", a[k * j]);

	for (m = 1; m < j; m++)
	{
	    fprintf(unit, "%10.0f", a[k * j + m]);
	}

	fputs("\n", unit);
    }
}
#define TEST_MADSUB	void main
TEST_MADSUB()
{
    static double TestMat_1[24] =
    {
	1, 2, 3, 4, 5, 6,
	1, 2, 3, 4, 5, 6,
	1, 2, 3, 4, 5, 6,
	1, 2, 3, 4, 5, 6
    };
    static double TestMat_2[24] =
    {
	1, 2, 3, 4,
	1, 2, 3, 4,
	1, 2, 3, 4,
	1, 2, 3, 4,
	1, 2, 3, 4,
	1, 2, 3, 4
    };
    static double TestMat_3[24];

    imatprt(TestMat_1, 4, 6, stdout, "Test Matrix 1 (A)");
    imatprt(TestMat_2, 6, 4, stdout, "Test Matrix 2 (B)");

    /* 1. */
    madsub(TestMat_1, 4, 6,
	   TestMat_2, 6, 4,
	   TestMat_3, 6, 4, ATB, APB);
    imatprt(TestMat_3, 6, 4, stdout, "\nTest # 1 - Matrix C = A' + B");
    fprintf(stderr, "Test # 1: ");
    Chk2MatEq(24, TestMat_3, ChkMat_AtPB);

    /* 2. */
    madsub(TestMat_1, 4, 6,
	   TestMat_2, 6, 4,
	   TestMat_3, 4, 6, ABT, APB);
    imatprt(TestMat_3, 4, 6, stdout, "\nTest # 2 - Matrix C = A + B'");
    fprintf(stderr, "Test # 2: ");
    Chk2MatEq(24, TestMat_3, ChkMat_APBt);

    imatprt(TestMat_1, 4, 6, stdout, "Test Matrix 1 (A)");
    imatprt(TestMat_2, 4, 6, stdout, "Test Matrix 2 (B)");

    /* 3. */
    madsub(TestMat_1, 4, 6,
	   TestMat_2, 4, 6,
	   TestMat_3, 4, 6, AB, APB);
    imatprt(TestMat_3, 4, 6, stdout, "\nTest # 3 - Matrix C = A + B");
    fprintf(stderr, "Test # 3: ");
    Chk2MatEq(24, TestMat_3, ChkMat_APB);

    imatprt(TestMat_1, 4, 6, stdout, "Test Matrix 1 (A)");

    /* 4. */
    madsub(TestMat_1, 4, 6,
	   TestMat_1, 4, 6,
	   TestMat_3, 4, 6, AB, AMB);
    imatprt(TestMat_3, 4, 6, stdout, "\nTest # 4 - Matrix C = A - A");
    fprintf(stderr, "Test # 4: ");
    Chk2MatEq(24, TestMat_3, ChkMat_AMA);

    imatprt(TestMat_1, 4, 6, stdout, "\nTest # 5 - Matrix 1 (A)");

    /* 5. */
    madsub(TestMat_1, 4, 6,
	   TestMat_1, 4, 6,
	   TestMat_3, 6, 4, ATBT, AMB);
    imatprt(TestMat_3, 6, 4, stdout, "\nTest Matrix C = A' - A'");
    fprintf(stderr, "Test # 5: ");
    Chk2MatEq(24, TestMat_3, ChkMat_AtMAt);

    imatprt(TestMat_1, 4, 6, stdout, "Test Matrix 1 (A)");
    imatprt(TestMat_2, 4, 6, stdout, "Test Matrix 2 (B)");

    /* 6. */
    madsub(TestMat_1, 4, 6,
	   TestMat_2, 4, 6,
	   TestMat_3, 4, 6, AB, MAMB);
    imatprt(TestMat_3, 4, 6, stdout, "\nTest # 6 - Matrix C = A + B");
    fprintf(stderr, "Test # 6: ");
    Chk2MatEq(24, TestMat_3, ChkMat_MAMB);

    /* TEST CASE 7 - WILL ABORT */
    imatprt(TestMat_1, 4, 6, stdout, "Test Matrix 1 (A)");
    imatprt(TestMat_2, 4, 6, stdout, "Test Matrix 2 (B)");
    madsub(TestMat_1, 4, 6,
	   TestMat_2, 4, 6,
	   TestMat_3, 5, 6, AB, MAMB);
    imatprt(TestMat_3, 4, 6, stdout, "\nTest # 6 - Matrix C = A + B");
    fprintf(stderr, "Test # 6: ");
    Chk2MatEq(24, TestMat_3, ChkMat_MAMB);
}
