// Connect.h



#if !defined(CONNECT_H)

#define CONNECT_H



#include <afx.h>        // For BOOL and CString

#include <afxdb.h>      // For CDatabase



class Connection : public CDatabase

{

public:

    static Connection* create(const CString& conSpec,BOOL readOnly = FALSE);



    long attach();      // Increments # clients

    long detach();      // Decrements # clients (self-destructs at 0)

    long nClients() const;

    void commit();

    void rollback();



private:

    long refCount;      // # clients using the connection



    // Only Connection::create can instantiate Connections:

    Connection();

    ~Connection();

};



#endif

