// DBXFace.h:   Abstract interface class for DBMS access



#if !defined(DBXFACE_H)

#define DBXFACE_H



#include "Connect.h"



class DBXFace

{

public:

    virtual ~DBXFace();

    Connection* getConnection() const;



protected:

    DBXFace(CRecordset*, Connection*);

    CRecordset* rsetp;

    Connection* connectp;



private:

    // Disallowed operations

    DBXFace(const DBXFace&);

    void operator=(const DBXFace&);

};



inline Connection* DBXFace::getConnection() const

{

    return connectp;

}



inline DBXFace::DBXFace(CRecordset* rp, Connection* cp)

{

    rsetp = rp;

    connectp = cp;

    cp->attach();

}



inline DBXFace::~DBXFace()

{

    delete rsetp;

    connectp->detach();

}



#endif

