// Employee.h



#if !defined(EMPLOYEE_H)

#define EMPLOYEE_H



#include <afx.h>

#include "Persist.h"



class EmpQuery;

class Connection;



class Employee : public Persist

{

public:

    Employee(Connection* cp, long id = 0L);

    Employee(const EmpQuery&);



    // Accessors:

    CString getLastName() const;

    CString getFirstName() const;

    CString getHomePhone() const;

    long getReportsTo() const;

    void setLastName(const CString&);

    void setFirstName(const CString&);

    void setHomePhone(const CString&);

    void setReportsTo(long);



    // Business Functions:

    Employee* getSuperior() const;



    // Persistence overides:

    virtual BOOL write();

    virtual BOOL remove();



private:

    CString lastName;

    CString firstName;

    CString homePhone;

    long reportsTo;



    // Disabled operations (i.e., not implemented)

    Employee(const Employee&);

    void operator=(const Employee&);

};



#endif

