// EmpQuery.h

#if !defined(EMP_QUERY_H)
#define EMP_QUERY_H

#include <afx.h>    // For CString
#include <afxdb.h>	// For CRecordset constants
#include "query.h"

class EmpQuery : public Query
{
    friend class EmpUpdate;
    friend class Employee;

public:
    EmpQuery(Connection*);

    // Overrides:
    virtual long getObjID() const;
    virtual CString getDesc() const;
    virtual char* SQLName(int) const;

    // Accessors:
    CString getLastName() const;
    CString getFirstName() const;
    CString getHomePhone() const;
    long getReportsTo() const;

    enum {TABLE_NAME, OBJ_ID, LAST_NAME, FIRST_NAME,
          HOME_PHONE, REPORTS_TO};

protected:
    enum {NFIELDS = 5};
    static char* queryTable[NFIELDS+1];
};

#endif
