// Persist.h



#if !defined(PERSIST_H)

#define PERSIST_H



#include <afx.h>        // For BOOL

#include "Connect.h"



class Persist

{

public:

    virtual ~Persist();

    virtual BOOL write() = 0;

    virtual BOOL remove() = 0;

    operator void*() const;



    // Accessors

    long getObjID() const;

    Connection* getConnection() const;



protected:

    Persist(Connection* cp, long id = 0L);



    // Attributes common to all persistent objects:

    long objID;

    Connection* connectp;

    BOOL valid;



private:

    // Disallowed operations

    Persist(const Persist&);

    void operator=(const Persist&);

};



inline Persist::Persist(Connection* cp, long id)

{

    objID = id;

    connectp = cp;

    connectp->attach();

    valid = FALSE;          // Must be determined in concrete class

}



inline long Persist::getObjID() const

{

    return objID;

}



inline Connection* Persist::getConnection() const

{

    return connectp;

}



inline Persist::~Persist()

{

    connectp->detach();

}



inline Persist::operator void*() const

{

    return valid ? (void*) this : 0;

}



#endif

