// Query.h: Abstract class for reading a database



#if !defined(QUERY_H)

#define QUERY_H



#include "DBXFace.h"

#include "Connect.h"



struct SortSpec

{

    int field;

    int order;

};



class Query : public DBXFace

{

public:

    BOOL execute(UINT = CRecordset::snapshot);



    // Query navigation functions

    BOOL first();

    BOOL last();

    BOOL next();

    BOOL prev();

    BOOL move(long);

    BOOL isEmpty() const;

    BOOL isEOF() const;

    BOOL isBOF() const;

    long getRecordCount() const;



    // Query-building functions

    virtual char* SQLName(int) const = 0;

    void startSelect();

    void addSelectCriteria(int, const CString&);

    void addSelect();

    void endSelect();

    void resetSelect();



    void startOrder();

    void addOrderCriteria(int, int);

    void endOrder();

    void resetOrder();



    // Accessors for attributes retrieved from table

    virtual long getObjID() const = 0;

    virtual CString getDesc() const = 0;



    // Accessors for this class

    CString getFilter() const;

    CString getSort() const;

    void setFilter(const CString& filt);

    void setSort(const CString& srt);



protected:

    Query(CRecordset*, Connection*);

    CString buildClause(int, const CString&);



    CString filter;

    CString sort;



private:

    enum {MAXSORTSPEC = 10};

    SortSpec sortSpecs[MAXSORTSPEC];

    int nSortSpecs;

    BOOL newClause;



    // Disallowed ops:

    Query(const Query&);

    void operator=(const Query&);

};



#endif

