// Test2.cpp:   Uses a customized Query object

#include "Connect.h"
#include "EmpQuery.h"
#include <iostream.h>

void displayResults(EmpQuery&);

main()
{
    // Connect to Database:
    Connection *cp = Connection::create("ODBC"
                                        "DSN=North Wind",TRUE);

    // Define Query with criteria via Filter String:
    EmpQuery q(cp);
    q.setFilter("[Employee ID] > 5");
    q.execute();
    displayResults(q);
    cout << endl;

    // Define Query with Query functions:
    q.startSelect();
    q.addSelectCriteria(EmpQuery::OBJ_ID,"field > 5");
    q.endSelect();
    q.execute();
    displayResults(q);

    cp->detach();
    return 0;
}

void displayResults(EmpQuery& q)
{
    while (!q.isEOF())
    {
        cout << '{' << q.getObjID()
             << ',' << q.getLastName()
             << ',' << q.getFirstName()
             << ',' << q.getHomePhone()
             << ',' << q.getReportsTo() << '}' << endl;
        q.next();
    }
}

/* Output:
{6,Suyama,Michael,(71) 555-7773,5}
{7,King,Jonathan,(71) 555-5598,5}
{8,Callahan,Linda,(206) 555-1189,2}
{9,Dodsworth,Annabella,(71) 555-4444,5}

{6,Suyama,Michael,123-456-7890,5}
{7,King,Jonathan,(71) 555-5598,5}
{8,Callahan,Linda,(206) 555-1189,2}
{9,Dodsworth,Annabella,(71) 555-4444,5}
*/
