// Test3.cpp:   Uses the Employee business object class

#include "Connect.h"
#include "Employee.h"
#include <iostream.h>

void displayEmployee(const Employee&);

main()
{
    // Connect to Database:
    Connection *cp = Connection::create("ODBC"
                                        "DSN=North Wind");

    // Retrieve an employee & boss:
    Employee emp(cp,6);
    displayEmployee(emp);
    Employee* boss = emp.getSuperior();
    cout << "Reports To: ";
    displayEmployee(*boss);
    delete boss;                // Dynamic object!

    // Update the object on disk:
    emp.setHomePhone("123-456-7890");
    emp.write();

    // Verify the change:
    Employee emp2(cp,6);
    displayEmployee(emp2);

    // Create new employee:
    Employee emp3(cp);
    emp3.setLastName("Claus");
    emp3.setFirstName("Santa");
    emp3.setHomePhone("unlisted");
    emp3.setReportsTo(1);
    emp3.write();

    // Verify the change:
    Employee emp4(cp,6);
    displayEmployee(emp4);

    cp->detach();
    return 0;
}

void displayEmployee(const Employee& e)
{
    cout << '{' << e.getObjID()
         << ',' << e.getLastName()
         << ',' << e.getFirstName()
         << ',' << e.getHomePhone() << '}' << endl;
}

/* Output:
{6,Suyama,Michael,(71) 555-7773}
Reports To: {5,Buchanan,B. L.,(71) 555-4848}
{6,Suyama,Michael,123-456-7890}
{10,Claus,Santa,unlisted}
*/
