// Update.h:    Abstract class for writing to a database



#if !defined(UPDATE_H)

#define UPDATE_H



// All classes derived from class Update have protected ctors, and

// the associated business object class must be a friend, e.g., class

// Employee is a friend to class EmpUpdate (to allow an Employee

// object to instantiate an EmpUpdate object). This enforces the policy

// that updates can only be done through objects.



#include "DBXFace.h"



class Update : public DBXFace

{

public:

    BOOL write();

    virtual long getID() const = 0;



protected:

    Update(CRecordset*, Connection*);

    long nextID();

    virtual CString getIDTable() const = 0;



private:

    // Disallowed ops:

    Update(const Update&);

    void operator=(const Update&);

};



#endif

