/**********************************************************/
/* GLOBALS.H - project-wide structures and defines        */
/**********************************************************/

#ifndef __GLOBALSdotH__
#define __GLOBALSdotH__

#include <windows.h>
#include "winsock.h"

/* defines */

#define POP3_PORT       110   /* pop servers listen on this port */

#define MAXDOMAINNAME   128   /* max length of a DNS host name */
#define MAXDIRECTORY    144   /* max disk directory size */
#define MAXIPSTRING     16    /* max length of IP Address string */
#define MAXNAME         30    /* max POP3 user name */
#define MAXPASS         30    /* max POP3 password */
#define MAILCHECKTIMER  1     /* timer object ID */
#define BUFFERSIZE      1024  /* POP3 x-fer buffer size */

/* different states of a POP3 window (some double as string-table lookups) */

#define POP_LOGIN       100 /* indicates POP3 client in login state */
#define POP_XFER        101 /* indicates POP3 client in message x-fer state */
#define POP_DELE        102 /* client wants server to delete a message */
#define POP_USER        103 /* client is about to send USER info */
#define POP_PASS        104 /* client is about to send PASS info */
#define POP_RETR        106 /* client is requesting the next message */
#define POP_STAT        107 /* client want the stats on the next message */
#define POP_VRFY        108 /* client waiting for server to verify password */
#define POP_QUIT        109 /* time to logoff */

/* prototypes */

long far PASCAL _export WinProc(HWND, UINT, WPARAM, LPARAM);
long far PASCAL _export Pop3Proc(HWND, UINT, WPARAM, LPARAM);
BOOL far PASCAL _export ConfigProc(HWND, UINT, WPARAM, LPARAM);

BOOL InitNetwork(void);       /* initializes the winsock layer */
void ShutDownNetwork(void);   /* shuts down the winsock layer */
void LookupServer(HWND);      /* performs DNS lookup on host */
void ConnectToServer(HWND);   /* makes socket connection to server */

void Display(char*);
BOOL LoadParms(void);
BOOL VerifyParms(void);
void SaveParms(void);

void Send(SOCKET, int, ...);
void SaveToFile(SOCKET, int);
void ProcBuffer(SOCKET, int);

/* structures */

typedef struct
  {
	  char ServerName[MAXDOMAINNAME];
	  char ServerIp[MAXIPSTRING];
	  char Pop3Name[MAXNAME];
	  char Pop3Pass[MAXPASS];
	  char MailDir[MAXDIRECTORY];
	  int  Timer;
  } stConfig;

#endif
