/**********************************************************/
/* NETWORK.C - Winsock support functions                  */
/**********************************************************/

#include "popmail.rh"
#include "winsock.h"
#include "globals.h"

extern WSADATA WSAData;
extern HWND hwndClient;
extern stConfig Config;
extern char HostInfo[MAXGETHOSTSTRUCT];

HANDLE TaskHandle;

BOOL InitNetwork(void)
  {
	  char work_buffer[60];

	  Display("Attempting to initialize winsock layer...\r\n");

	  if (WSAStartup(0x101, &WSAData)) return FALSE;

	  if ((((int) LOBYTE(WSAData.wVersion) > 1) &&
		 ((int) HIBYTE(WSAData.wVersion > 1)) &&
			(((int) LOBYTE(WSAData.wHighVersion) < 1) &&
			  ((int) HIBYTE(WSAData.wHighVersion) < 1))))
				 return FALSE;

	  sprintf(work_buffer, "PopMail Detected: %s\r\n", WSAData.szDescription);
	  Display(work_buffer);
	  sprintf(work_buffer, "Maximum Sockets : %d\r\n", WSAData.iMaxSockets);
	  Display(work_buffer);

	  return TRUE;
  }

void ShutDownNetwork(void)
  {
	  Display("Shutting down winsock layer...\r\n");
	  WSACleanup();
  }

void LookupServer(HWND hwnd)
  {
	  char work_buffer[100];

	  sprintf(work_buffer, "Looking Up  : %s\r\n", Config.ServerName);
	  Display(work_buffer);

	  TaskHandle = WSAAsyncGetHostByName(hwnd, IMSG_HOSTFOUND, Config.ServerName, HostInfo, MAXGETHOSTSTRUCT);
  }

void ConnectToServer(HWND hwnd)
  {
	  int nError;
	  SOCKET Socket;
	  SOCKADDR_IN LocalAddr, ServerAddr;

	  Display("Connecting to server.\r\n");

	  Socket = socket(AF_INET, SOCK_STREAM, 0);
	  if (Socket != INVALID_SOCKET)
		 {
			LocalAddr.sin_family = AF_INET;
			LocalAddr.sin_port = 0; /* winsock will assign a local port number */
			LocalAddr.sin_addr.s_addr = htonl(INADDR_ANY);

			Display("Binding local socket.\r\n");

			if (bind(Socket, (LPSOCKADDR)&LocalAddr, sizeof(LocalAddr)) != SOCKET_ERROR)
			  {
				  ServerAddr.sin_family = AF_INET;
				  ServerAddr.sin_port = htons(POP3_PORT);
				  ServerAddr.sin_addr.s_addr = inet_addr(Config.ServerIp);

				  Display("Selecting relevant network events.\r\n");

				  if (WSAAsyncSelect(Socket, hwnd, IMSG_NETIO, FD_CONNECT | FD_READ | FD_CLOSE) != SOCKET_ERROR)
					 {
						 Display("Requesting stream socket connection to server's POP port.\r\n");

						 if (connect(Socket, (LPSOCKADDR)&ServerAddr, sizeof(ServerAddr)) == SOCKET_ERROR)
							{
								nError = WSAGetLastError();
								if (nError != WSAEWOULDBLOCK)
								  Display("Error connecting bound socket to server!");
							}
					 } else Display("Error setting up WSAAsyncSelect on bound socket!");
			  } else Display("Error binding socket to address.r\n");
		 } else Display("Error creating outbound socket.\r\n");
  }
