/* SPRITE.C by Jeff Heaton - Sprite Engine */
#include "sprite.h"

struct SPRITE *firstSprite=NULL;
extern BITMAPINFO *info;
extern BYTE *bitmap;

/* CreateSprite - Create a sprite 'h' height and 'w' wide 
	that uses base for its pixel map */
struct SPRITE *CreateSprite(int h,int w,BYTE *base)
{
struct SPRITE *sprite;
	sprite=malloc(sizeof(struct SPRITE));
	SpriteSetPos(sprite,0,0);
	SpriteSetFrame(sprite,0);
	SpriteSetBase(sprite,base);
	SpriteShow(sprite,FALSE);
	sprite->next=firstSprite;
	sprite->h=h;
	sprite->w=w;
	firstSprite=sprite;
	return sprite;
}

/* Remove and delete 'delme' */
void DeleteSprite(struct SPRITE *delme)
{
struct SPRITE *sprite;
	if(delme==firstSprite) {
		firstSprite=firstSprite->next;
		free(delme);
		return;
		}
	sprite=firstSprite;
	while(sprite!=NULL) {
		if(sprite->next==delme) {
			sprite->next=delme->next;
			free(delme);
			return;
			}
		sprite=sprite->next;
		}
}

/* RenderSprites - Draw all sprites into the master
	bitmap.  This routine does no on-screen drawing */		 
void RenderSprites(HWND hwnd)
{
int maxx,maxy,x,y,baseInc;
BYTE *base,*s;
struct SPRITE *sprite;

	maxx=info->bmiHeader.biWidth;
	maxy=-info->bmiHeader.biHeight;
	GdiFlush();
	sprite=firstSprite;
	while(sprite!=NULL) {
		if( (sprite->xLoc>0) && 
			(sprite->yLoc>0) && 
			((sprite->xLoc+sprite->w)<maxx) && 
			((sprite->yLoc+sprite->h)<maxy) ) {
			
			s=sprite->base;
			base=bitmap+(sprite->yLoc*maxx)+sprite->xLoc;
			baseInc=maxx-sprite->w;
			x=0;
			y=sprite->h;
			while(y) {
				if(*s!=*sprite->base)
					*base=*s;
				base++;
				s++;
				x++;
/* Is it time to wrap to the next line? */
				if(x==sprite->w) {
					base+=baseInc;
					x=0;
					y--;
					}
				}
			}
		sprite=sprite->next;
		}
	GdiFlush();
}
