// reversit.cpp   use cin.get(), reverse spelling of a word or phrase.
//#define STDIO

#include <string.h>
#ifdef STDIO
#include <stdio.h>
#else
#include <iostream.h>
#endif

void reversit(char[]);                    // prototype
void swapchar(char *cp1, char *cp2);    // prototype

const int MAX=80;                        // max string length
char str[MAX];                          // global for watching in debug mode

int main(void)
{
    char yesno;
    const char *prompt = "\nEnter a word or a phrase to reverse:\n";
    do
    {
        str[0] = '\0';
#ifdef STDIO
        printf(prompt);
        gets(str);
#else
        cout << prompt;
        cin.get(str, MAX);        // read in phrase, include blanks.
#endif

        reversit(str);

#ifdef STDIO
        printf("\nThe reverse is:\n%s\n\nDo another? y/n", str);
        yesno = getchar();
        fflush(stdin);  // discard ALL characters in buffer
#else
        cout << "\nThe reverse is:\n" << str << "\n\nDo another? y/n";
        cin >> yesno;
        cin.ignore();    // discard ONE character
#endif
    } while (yesno == 'y');
    return (0);
}

void reversit(char s[])            //    function to reverse string
{
    int j = (strlen(s)-1);      // index of last character (not \0)
    if (j<0) return;            // nothing to do if strlen == 0
    for (int i = 0; i <= j/2; i++)
        swapchar(&s[i], &s[j-i]);
}

void swapchar(char *cp1, char *cp2) //function to swap characters
{
    char temp = *cp1;
    *cp1 = *cp2;
    *cp2 = temp;
}

// end of reversit.cpp
