/*
 *	demo.cpp
 *
 *	This file demonstrates how dynamic message passing can be used
 *	with the proposed implementation.
 *
 *	(C) Copyright 1996, Pierre Arnaud, OPaC bright ideas
 *		CH-1437 Suscevaz, Pierre.Arnaud@di.epfl.ch
 *		http://diwww.epfl.ch/w3lami/team/arnaud/
 */

#include <stdio.h>
#include "dynamic.h"

/*
 *	Test class definition, with additional 'GetRuntime' method.
 */

class Button : public Object
{
	//	...
public:
	virtual Runtime* GetRuntime () const;
	virtual Bool SetSize (int dx, int dy);
	virtual Bool SetName (const char* name);
};

/*
 *	Test class implementation. 
 */

PUBLISH_CLASS (Button);

PUBLISH_METHOD (Button, SetSize);
PUBLISH_ARG (width, int);
PUBLISH_ARG (height, int);
PUBLISH_CALL (SetSize (width, height));

Bool
Button::SetSize (int dx, int dy)
{
	printf ("Button::SetSize (%d, %d) called\n", dx, dy);
	return TRUE;
}

PUBLISH_METHOD (Button, SetName);
PUBLISH_ARG (name, const char*);
PUBLISH_CALL (SetName (name));

Bool
Button::SetName (const char* name)
{
	printf ("Button::SetName (\"%s\") called\n", name);
	return TRUE;
}


/***************************************************************/

void
main ()
{
	Button  button;

	Message setSize ("SetSize");
	Message setName ("SetName");
	
	button <- setSize << 10 << 20;
	button <- setSize << 50 << 10;
	button <- setName << "Ok";
	
	getchar ();
}
