/*
 *	dynamic.cpp
 *
 *	This file implements the Message class needed to handle dynamic
 *	message passing in C++.
 *
 *	(C) Copyright 1996, Pierre Arnaud, OPaC bright ideas
 *		CH-1437 Suscevaz, Pierre.Arnaud@di.epfl.ch
 *		http://diwww.epfl.ch/w3lami/team/arnaud/
 */

#include "dynamic.h"

Message&
Message::SetValue (Value value, Type type)
{
	List* elem = new List (value, type);

	(this->tail ? this->tail->next : this->head) = elem;
	(this->tail                                ) = elem;

	return *this;
}

Message&
Message::GetValue (Value& value, Type type)
{
	if (this->iter == 0) {
		throw MSG_EXC_TOO_MANY_PARAMS;
	}
	
	if (this->iter->type != type) {
		throw MSG_EXC_BAD_PARAM_TYPE;
	}

	value      = this->iter->value;
	this->iter = this->iter->next;
	
	return *this;
}

void
Message::SetMethod (const char* name)
{
	this->method = name;
}

void
Message::Clear ()
{
	if (this->head) {
		delete this->head;
	}
	
	this->head = 0;
	this->tail = 0;
}

Bool
Message::Send (Object* target)
{
	Runtime*   runtime = target->GetRuntime ();
	TrampoFunc trampo  = runtime->GetFunction (this->method);

	if (trampo) {
		this->iter = this->head;
		return (trampo)(*this, target);
	}
	
	return FALSE;
}
