/*
 *	runtime.cpp
 *
 *	This file implements the Runtime class needed to handle dynamic
 *	message passing in C++. It also provides a constructor and a
 *	destructor for class Object.
 *
 *	(C) Copyright 1996, Pierre Arnaud, OPaC bright ideas
 *		CH-1437 Suscevaz, Pierre.Arnaud@di.epfl.ch
 *		http://diwww.epfl.ch/w3lami/team/arnaud/
 */

#include <string.h>
#include "dynamic.h"

void
Runtime::AddFunction (const char* name, TrampoFunc func)
{
	List* elem  = new List (name, func);
	
	(this->tail ? this->tail->next : this->head) = elem;
	(this->tail                                ) = elem;
}

TrampoFunc
Runtime::GetFunction (const char* name) const
{
	List* elem = this->head;
	
	while (elem) {
		if (strcmp (elem->name, name) == 0) {
			return elem->func;
		}
		elem = elem->next;
	}
	
	return 0;
}

/*
 *	The implementation of class Object is very partial :-)
 */

PUBLISH_CLASS (Object);

Object::Object ()
{
}

Object::~Object ()
{
}
