//----------------------------------------------------------------------
//
// Double Scan
//
// Copyright (C) 1995, Mark Russinovich and Bryce Cogswell
//
// You have the right to use and publish this code and its related
// files as long as the authors are given credit.
//
//----------------------------------------------------------------------

#include <windows.h>
#include <dos.h> 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <shellapi.h>
#include <process.h>
#include "ctl3d.h"
#include "resource.h"  

// vxd commands
#define VDBLSCND_INIT		0
#define VDBLSCND_SCAN		1  
               
// pager types               
char PagerTypes[][16] = { "DOS", "BIOS", "BLCK", "IFS" };
              
// signature we fill memory with              
char signature[] = "MARKBRYC";		// Must be 8 bytes in length
char *vdblscndid = "dblscan";
UINT waitperiod = 0;				// seconds

char msgbuf[ 200 ];

HINSTANCE 	hInst;
DWORD		dwVxDEntry;               

// statistics data structure that the vxd fills in
struct vxdstats {   
	DWORD	DiskWrites;
	DWORD	PagesInRAM;
	DWORD	PagesOnDisk;
} VxDStats;    


// total pages allocated successfully
DWORD	TotalAllocated;

// memory size in pages
WORD	MemSize;
            
// timer ID
UINT hTimer;

// OOP my ass
FARPROC lpTest;
HWND  hTestDlg;
DWORD		startTime;
DWORD		endTime;
HGLOBAL  	page_array_handle;
HGLOBAL far *page_array;
DWORD		nPages;
		            
void EndExperiment( HWND hDlg );


//----------------------------------------------------------------------
//
// Abort
//
// Exits everything.
//
//----------------------------------------------------------------------
void Abort( HWND hWnd, char * Msg )
{
        MessageBox( hWnd, Msg, "Double Scan",
               		MB_ICONEXCLAMATION|MB_OK );
        EndDialog( hWnd, 1 );
        PostQuitMessage( 1 );
}


//----------------------------------------------------------------------
//  
// centerDialog
// 
// Centers the dialog box on the screen.
//
//----------------------------------------------------------------------
VOID centerWindow( HWND hWnd )
{
	RECT            aRt;

	// center the dialog box
	GetWindowRect( hWnd, &aRt );
	OffsetRect( &aRt, -aRt.left, -aRt.top );
	MoveWindow( hWnd,
			((GetSystemMetrics( SM_CXSCREEN ) -
				aRt.right ) / 2 + 4) & ~7,
  			(GetSystemMetrics( SM_CYSCREEN ) -
				aRt.bottom) / 2,
			aRt.right, aRt.bottom, 0 );
} 


//----------------------------------------------------------------------
//  
// GenericDlgProc
//
// Catch all for our small pop-ups.
//
//----------------------------------------------------------------------
BOOL FAR PASCAL _export GenericDlgProc (HWND hDlg, UINT message, UINT wParam,
                                                               LONG lParam) {
	switch (message) {
	case WM_INITDIALOG :
		centerWindow( hDlg );
		return TRUE ;
 
	case WM_COMMAND :
		switch (wParam) {
		case IDOK :
			EndDialog (hDlg, 0) ;
			return TRUE ;
		}
		break ; 
	case WM_CLOSE:
		EndDialog (hDlg, 0);
		return TRUE;
	}
	return FALSE ;
}


//----------------------------------------------------------------------
//  
// ResultDlgProc
//
// Overview of whether or not compression was found.
//
//----------------------------------------------------------------------
BOOL FAR PASCAL _export ParmDlgProc (HWND hDlg, UINT message, UINT wParam,
                                                              LONG lParam)
{
	switch (message) {
	case WM_INITDIALOG :
		Ctl3dSubclassDlgEx(hDlg, CTL3D_ALL);
		SetDlgItemText( hDlg, IDSIG, signature );
		SetDlgItemInt( hDlg, IDWAIT, waitperiod, FALSE );
		centerWindow( hDlg );
		return TRUE ;
 
	case WM_COMMAND :
		switch (wParam) {
		case IDOK :  {
			char sig[ 20 ];
			UINT per;
			BOOL ok;
			if ( GetDlgItemText( hDlg, IDSIG, sig, sizeof sig ) != 8 )  {
				MessageBox( hDlg, "Signature must be exactly 8 characters",
							NULL, MB_OK );
				return TRUE;
			}
			per = GetDlgItemInt( hDlg, IDWAIT, &ok, FALSE );
			if ( ! ok )  {
				MessageBox( hDlg, "Illegal wait time", NULL, MB_OK );
				return TRUE;
			}
			strcpy( signature, sig );
			waitperiod = per;
			EndDialog (hDlg, 0);
			return TRUE;
		}
		
		case IDWAIT:
			return TRUE;
		case IDSIG:
			return TRUE;
		}
		break ; 
	case WM_CLOSE:
		EndDialog (hDlg, 0);
		return TRUE; 
	case WM_CTLCOLOR:
   		return Ctl3dCtlColorEx( hDlg, wParam, lParam);

	}
	return FALSE ;
} 


//----------------------------------------------------------------------
//  
// ResultDlgProc
//
// Overview of whether or not compression was found.
//
//----------------------------------------------------------------------
BOOL FAR PASCAL _export ResultDlgProc (HWND hDlg, UINT message, UINT wParam,
                                                               LONG lParam) {
	switch (message) {
	case WM_INITDIALOG :
	                                                    
		// if we found at least as many pages as we allocated, then no compression
		// occurred!!!!	                                                    	
		if( VxDStats.PagesOnDisk + VxDStats.PagesInRAM >= TotalAllocated ) {
 			wsprintf( msgbuf, "NO COMPRESSION FOUND!!" );
			SetDlgItemText( hDlg, IDC_RESULT, msgbuf );		
		} else {
			wsprintf( msgbuf, "Compression has been detected." );
			SetDlgItemText( hDlg, IDC_RESULT, msgbuf );
		}
		centerWindow( hDlg );
		return TRUE ;
 
	case WM_COMMAND :
		switch (wParam) {
		case IDOK :
			EndDialog (hDlg, 0) ;
			return TRUE ;
		}
		break ; 
	case WM_CLOSE:
		EndDialog (hDlg, 0);
		return TRUE;
	}
	return FALSE ;
} 


//----------------------------------------------------------------------
//                                                    
// RunExperiment
//
// This routine allocates an amount of memory equal to the computer's
// physical memory size. This is accomplished in a loop that global allocs
// 1 page at a time, filling it with our recognizable signature. Note
// that thes pages are not aligned on the processor page boundaries so
// the Double Scan vxd must be careful about counting pages. After all the
// memory has been allocated and filled, the vxd is called to scan physical
// ram for uncompressed pages. It then returns the result of the experiment
// to us to print. We then zero fill the memory as we release it so that
// in case we want to run again (we really shoudn't) we have gotten rid
// of most, if not all, instances of our signature from memory. We allocate
// pages here, rather than a vxd so that real windows application behavior
// is simulated.
//
//----------------------------------------------------------------------
void RunExperiment( HWND hDlg )
{
	WORD 		StatAddr = (WORD) &VxDStats;
	DWORD		page;
 	int 		len = strlen( signature );
 	WORD 		our_sig = (WORD) signature;  
	FARPROC 	lpProcParm;     
    
    // ask for experiment parameters
	lpProcParm = MakeProcInstance( (FARPROC)ParmDlgProc, hInst );
	DialogBox( hInst, "PARAMS", hDlg, (DLGPROC)lpProcParm );
	FreeProcInstance( lpProcParm );
	UpdateWindow(hDlg);
    
    // put up be patient message
	lpTest = MakeProcInstance( (FARPROC)GenericDlgProc, hInst );
	hTestDlg = CreateDialog( hInst, "EXPERIMENT", hDlg, (DLGPROC)lpTest );
				
	// Tell VxD to start counting things
     _asm {
            mov     dx, VDBLSCND_INIT
            mov		bx, our_sig
            mov     ax, StatAddr
            call    dwVxDEntry
            mov		MemSize, ax
    } 
    
    // timestamp the start                              
    nPages = MemSize;
	startTime = GetTickCount();
    
	// allocate buffer
	page_array_handle = GlobalAlloc( GPTR, nPages * sizeof(page_array_handle) );
	page_array = (HGLOBAL far *) GlobalLock( page_array_handle );
			
	// loop over pages, locking/filling/unlocking 
	TotalAllocated = 0;
	for ( page = 0; page < nPages; ++page )  {
		int j, i;

		char far * page_data;
		if( !(page_array[page] = GlobalAlloc( GMEM_FIXED|GMEM_NODISCARD, 4096 ))) {
			page_array[page] = 0;
		} else {
			// increment count
			TotalAllocated++;
			 
			// lock the buffer and get its address
			page_data = GlobalLock( page_array[page] ); 
		
			// fill buffer with identifying string
			i= 0;
			for ( j = 0; j < 4096; j ++ ) {
				page_data[j] = signature[i++];
				if( !signature[i] )
					i = 0;
			}
			GlobalUnlock( page_array[page] );   
		}
	} 
	
	// timestamp end of test
	endTime = GetTickCount();

	// arrange for us to be notified when wait period is over.
	if ( waitperiod )  {
		hTimer = SetTimer( hDlg, 666, waitperiod*1000, NULL );
		if ( hTimer == NULL )  {
			MessageBox( hDlg, "Error setting timer", NULL, MB_OK );
		}
	} else {
		hTimer = NULL;
		EndExperiment( hDlg );
	}
}


//----------------------------------------------------------------------
//  
// EndExperiment
//
// After any delay has expired, we can ask the VxD to scan RAM for the
// signature and return to us the results of its tabulations, which 
// we then print in the dialog.
//
//----------------------------------------------------------------------
void EndExperiment( HWND hDlg )
{	
	FARPROC 	lpProcReboot;
	WORD		pagertype;
	DWORD		page;
 	int 		len = strlen( signature );
 	WORD 		our_sig = (WORD) signature;  
  	
 	// ask for vxd to scan
    _asm {
        mov     dx, VDBLSCND_SCAN
        call    dwVxDEntry
        mov		pagertype, ax
    }  

	if ( hTimer )
		KillTimer( hDlg, hTimer );
		                                       
	// update results  
	if( pagertype == -1 ) 
		SetDlgItemText( hDlg, IDC_PAGERTYPE, "NOPG" );
	else 
		SetDlgItemText( hDlg, IDC_PAGERTYPE, PagerTypes[pagertype] );
 	wsprintf( msgbuf, "%d", VxDStats.PagesInRAM );
	SetDlgItemText( hDlg, IDC_PAGESINRAM, msgbuf );
	wsprintf( msgbuf, "%d", VxDStats.PagesOnDisk );
	SetDlgItemText( hDlg, IDC_PAGESONDISK, msgbuf );
	wsprintf( msgbuf, "%d", VxDStats.DiskWrites );
	SetDlgItemText( hDlg, IDC_PAGESWRITTEN, msgbuf );
	wsprintf( msgbuf, "%d", TotalAllocated );
	SetDlgItemText( hDlg, IDC_PAGESALLOCATED, msgbuf );
	wsprintf( msgbuf, "%d", VxDStats.PagesOnDisk + VxDStats.PagesInRAM );
	SetDlgItemText( hDlg, IDC_TOTALPAGES, msgbuf );
	wsprintf( msgbuf, "%d", (endTime-startTime)/1000);
	SetDlgItemText( hDlg, IDC_TOTALTIME, msgbuf );
	                              
	// clear pages so that we don't find them later                              
	for ( page = 0; page < nPages; ++page )  { 
		if( page_array[page] ) {
			char far * page_data = GlobalLock( page_array[page] );
			_fmemset( page_data, 0, 4096 );
			GlobalUnlock( page_array[page] );
			GlobalFree( page_array[page] );   
		}
	}
	GlobalUnlock(page_array_handle);						
 	GlobalFree(page_array_handle); 
 	
	// kill test in progress dialog
	DestroyWindow( hTestDlg );     
	FreeProcInstance( lpTest );
 	
 	// put up reboot warning dialog  
 	UpdateWindow( hDlg );
	lpProcReboot = MakeProcInstance( (FARPROC)ResultDlgProc, hInst );
	DialogBox( hInst, "REBOOT", hDlg, (DLGPROC)lpProcReboot );
	FreeProcInstance( lpProcReboot );
}


//----------------------------------------------------------------------
//  
// MainDialog
// 
// Message handling procedure.
//
//----------------------------------------------------------------------
BOOL CALLBACK MainDialog( HWND hDlg, UINT message, WPARAM wParam, 
			    LPARAM lParam )
{
    switch ( message ) {
    case WM_INITDIALOG:
    
        // open the handle to the VXD 
        _asm {
        		push	es 
        		push	di 
        		mov		di, 0
				push	0
				pop		es
                mov     ax, 0x168A
                mov     si, vdblscndid
                int     0x2F
                mov     word ptr dwVxDEntry, di
                mov     word ptr dwVxDEntry+2, es 
                pop		di
                pop		es
        }
        
        // vxd not there -error
        if( !dwVxDEntry )  {
 	       	wsprintf( msgbuf, "Couldn't open vxd\nSee the Readme" );
	       	Abort( hDlg, msgbuf );
            return(0);
        } 
        
        // intialize readings
        SetDlgItemText( hDlg, IDC_PAGERTYPE, "?" );
		SetDlgItemText( hDlg, IDC_DISKWRITES, "0" );
		SetDlgItemText( hDlg, IDC_PAGESALLOCATED, "0" );
		SetDlgItemText( hDlg, IDC_PAGESINRAM, "0" );
		SetDlgItemText( hDlg, IDC_PAGESONDISK, "0" ); 
		SetDlgItemText( hDlg, IDC_TOTALTIME, "0" );
		SetDlgItemText( hDlg, IDC_TOTALPAGES, "0" );
		centerWindow( hDlg );
		return FALSE;
		break;

    case WM_COMMAND:
    	switch( LOWORD( wParam ) ) {
    	
    	// start test run
    	case IDSTART: {
 			RunExperiment( hDlg );                                       
  			return TRUE;
		}
        
        // exit
		case IDCANCEL:
 			// unregister 3-d
			EndDialog (hDlg, 0);
			return TRUE;
        
        // about box
		case IDABOUT:  {
             FARPROC lpProcAbout;
             lpProcAbout = MakeProcInstance( (FARPROC)GenericDlgProc, hInst );
             DialogBox( hInst, "ABOUT", hDlg, (DLGPROC)lpProcAbout );
             FreeProcInstance( lpProcAbout );
             return TRUE;
 		}
        
        // pop-up notepad with readme text
		case IDHELP:
 			if ( ShellExecute( hDlg, "open", "readme.txt", NULL, 
 								"/dblscan", SW_SHOWNORMAL	) <= 32 ) {
 				MessageBox( hDlg, "Can't find help file", NULL, MB_OK );
 			}
			return TRUE;
		
		default:
			break;
		}
		break;
		
	
	case WM_TIMER:
		EndExperiment( hDlg );
		break;
	
	case WM_CLOSE:
		EndDialog (hDlg, 0) ;
		return TRUE ;
	
    default:
    	break;
	}
	return FALSE; 
}
                                              
 
//----------------------------------------------------------------------
//  
// WinMain
// 
// Fires up a dialog box type window.
//
//----------------------------------------------------------------------
int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
        				LPSTR lpCmdLine, int nCmdShow )
{
	MSG         msg;

   	hInst = hInstance;
   	
   	// register 3-d controls
   	Ctl3dRegister( hInst );
	Ctl3dAutoSubclass( hInst );

 	// create the dialog window
    DialogBox( hInstance, "DIALOG", NULL, MainDialog );  
    
    // unregister 3-d
	Ctl3dUnregister( hInst );

	return msg.wParam;   	
}
