// DBLSCAN.H - include file for VxD DBLSCAN

#include <vtoolsc.h>

#define DBLSCAN_Major		1
#define DBLSCAN_Minor		0
#define DBLSCAN_DeviceID	UNDEFINED_DEVICE_ID
#define DBLSCAN_Init_Order	UNDEFINED_INIT_ORDER


#define DBLSCAN_ID_STRING "dblscan"


//----------------------------------------------------------------------
//
// PagingFile service definitions
//
//----------------------------------------------------------------------
// Pagefile service definition table. The services and their
// order were obtained from the pagefile.inc file in the win95
// DDK.

#define PAGEFILE_Service  Declare_Service
Begin_Service_Table(PAGEFILE)

PAGEFILE_Service    (PageFile_Get_Version)
PAGEFILE_Service    (PageFile_Init_File)
PAGEFILE_Service    (PageFile_Clean_Up)
PAGEFILE_Service    (PageFile_Grow_File)
PAGEFILE_Service    (PageFile_Read_Or_Write)
PAGEFILE_Service    (PageFile_Cancel)
PAGEFILE_Service    (PageFile_Test_IO_Valid)
PAGEFILE_Service    (PageFile_Get_Size_Info)
PAGEFILE_Service    (PageFile_Set_Async_Manager)
PAGEFILE_Service    (PageFile_Call_Async_Manager)

End_Service_Table(PAGEFILE)

// definitions for type of paging going on
#define PAGERNONE    1
#define PAGERDOS     2
#define PAGERFAST    3

//----------------------------------------------------------------------
//
// DOS and BIOS file I/O definitions
//
//----------------------------------------------------------------------

// bios
#define BIOSREAD   0x2
#define BIOSWRITE  0x3

// dos
#define DOSREAD    0x3F
#define DOSWRITE   0x40

// ifsmgr
#define R0_READFILE               0xD600
#define R0_WRITEFILE              0xD601


//----------------------------------------------------------------------
//
// IFSMgr service definitions
//
//----------------------------------------------------------------------
// 
// We want to compile this for win31 and win95 under the win31 
// build environment so we define ifsmgr stuff here since its only
// applicable to win95
//


#define IFSMGR_DEVICE_ID                0x40
#define IFSMgr_Service  Declare_Service
Begin_Service_Table(IFSMGR)

IFSMgr_Service  (IFSMgr_Get_Version)
IFSMgr_Service  (IFSMgr_RegisterMount)
IFSMgr_Service  (IFSMgr_RegisterNet)
IFSMgr_Service  (IFSMgr_RegisterMailSlot)
IFSMgr_Service  (IFSMgr_Attach)
IFSMgr_Service  (IFSMgr_Detach)
IFSMgr_Service  (IFSMgr_Get_NetTime)
IFSMgr_Service  (IFSMgr_Get_DOSTime)
IFSMgr_Service  (IFSMgr_SetupConnection)
IFSMgr_Service  (IFSMgr_DerefConnection)
IFSMgr_Service  (IFSMgr_ServerDOSCall)
IFSMgr_Service  (IFSMgr_CompleteAsync)
IFSMgr_Service  (IFSMgr_RegisterHeap)
IFSMgr_Service  (IFSMgr_GetHeap)
IFSMgr_Service  (IFSMgr_RetHeap)
IFSMgr_Service  (IFSMgr_CheckHeap)
IFSMgr_Service  (IFSMgr_CheckHeapItem)
IFSMgr_Service  (IFSMgr_FillHeapSpare)
IFSMgr_Service  (IFSMgr_Block)
IFSMgr_Service  (IFSMgr_Wakeup)
IFSMgr_Service  (IFSMgr_Yield)
IFSMgr_Service  (IFSMgr_SchedEvent)
IFSMgr_Service  (IFSMgr_QueueEvent)
IFSMgr_Service  (IFSMgr_KillEvent)
IFSMgr_Service  (IFSMgr_FreeIOReq)
IFSMgr_Service  (IFSMgr_MakeMailSlot)
IFSMgr_Service  (IFSMgr_DeleteMailSlot)
IFSMgr_Service  (IFSMgr_WriteMailSlot)
IFSMgr_Service  (IFSMgr_PopUp)
IFSMgr_Service  (IFSMgr_printf)
IFSMgr_Service  (IFSMgr_AssertFailed)
IFSMgr_Service  (IFSMgr_LogEntry)
IFSMgr_Service  (IFSMgr_DebugMenu)
IFSMgr_Service  (IFSMgr_DebugVars)
IFSMgr_Service  (IFSMgr_GetDebugString)
IFSMgr_Service  (IFSMgr_GetDebugHexNum)
IFSMgr_Service  (IFSMgr_NetFunction)
IFSMgr_Service  (IFSMgr_DoDelAllUses)
IFSMgr_Service  (IFSMgr_SetErrString)
IFSMgr_Service  (IFSMgr_GetErrString)
IFSMgr_Service  (IFSMgr_SetReqHook)
IFSMgr_Service  (IFSMgr_SetPathHook)
IFSMgr_Service  (IFSMgr_UseAdd)
IFSMgr_Service  (IFSMgr_UseDel)
IFSMgr_Service  (IFSMgr_InitUseAdd)
IFSMgr_Service  (IFSMgr_ChangeDir)
IFSMgr_Service  (IFSMgr_DelAllUses)
IFSMgr_Service  (IFSMgr_CDROM_Attach)
IFSMgr_Service  (IFSMgr_CDROM_Detach)
IFSMgr_Service  (IFSMgr_Win32DupHandle)
IFSMgr_Service  (IFSMgr_Ring0_FileIO)
IFSMgr_Service  (IFSMgr_Win32_Get_Ring0_Handle)
IFSMgr_Service  (IFSMgr_Get_Drive_Info)
IFSMgr_Service  (IFSMgr_Ring0GetDriveInfo)
IFSMgr_Service  (IFSMgr_BlockNoEvents)
IFSMgr_Service  (IFSMgr_NetToDosTime)
IFSMgr_Service  (IFSMgr_DosToNetTime)
IFSMgr_Service  (IFSMgr_DosToWin32Time)
IFSMgr_Service  (IFSMgr_Win32ToDosTime)
IFSMgr_Service  (IFSMgr_NetToWin32Time)
IFSMgr_Service  (IFSMgr_Win32ToNetTime)
IFSMgr_Service  (IFSMgr_MetaMatch)
IFSMgr_Service  (IFSMgr_TransMatch)
IFSMgr_Service  (IFSMgr_CallProvider)
IFSMgr_Service  (UniToBCS)
IFSMgr_Service  (UniToBCSPath)
IFSMgr_Service  (BCSToUni)
IFSMgr_Service  (UniToUpper)
IFSMgr_Service  (UniCharToOEM)
IFSMgr_Service  (CreateBasis)
IFSMgr_Service  (MatchBasisName)
IFSMgr_Service  (AppendBasisTail)
IFSMgr_Service  (FcbToShort)
IFSMgr_Service  (ShortToFcb)
IFSMgr_Service  (IFSMgr_ParsePath)
IFSMgr_Service  (Query_PhysLock)
IFSMgr_Service  (_VolFlush)
IFSMgr_Service  (NotifyVolumeArrival)
IFSMgr_Service  (NotifyVolumeRemoval)
IFSMgr_Service  (QueryVolumeRemoval)
IFSMgr_Service  (IFSMgr_FSDUnmountCFSD)
IFSMgr_Service  (IFSMgr_GetConversionTablePtrs)
IFSMgr_Service  (IFSMgr_CheckAccessConflict)
IFSMgr_Service  (IFSMgr_LockFile)
IFSMgr_Service  (IFSMgr_UnlockFile)
IFSMgr_Service  (IFSMgr_RemoveLocks)
IFSMgr_Service  (IFSMgr_CheckLocks)
IFSMgr_Service  (IFSMgr_CountLocks)
IFSMgr_Service  (IFSMgr_ReassignLockFileInst)
IFSMgr_Service  (IFSMgr_UnassignLockList)
IFSMgr_Service  (IFSMgr_MountChildVolume)
IFSMgr_Service  (IFSMgr_UnmountChildVolume)
IFSMgr_Service  (IFSMgr_SwapDrives)
IFSMgr_Service  (IFSMgr_FSDMapFHtoIOREQ)
IFSMgr_Service  (IFSMgr_FSDParsePath)
IFSMgr_Service  (IFSMgr_FSDAttachSFT)
IFSMgr_Service  (IFSMgr_GetTimeZoneBias)
IFSMgr_Service  (IFSMgr_PNPEvent)
IFSMgr_Service  (IFSMgr_RegisterCFSD)
IFSMgr_Service  (IFSMgr_Win32MapExtendedHandleToSFT)
IFSMgr_Service  (IFSMgr_DbgSetFileHandleLimit)
IFSMgr_Service  (IFSMgr_Win32MapSFTToExtendedHandle)
IFSMgr_Service  (IFSMgr_FSDGetCurrentDrive)
IFSMgr_Service  (IFSMgr_InstallFileSystemApiHook)
IFSMgr_Service  (IFSMgr_RemoveFileSystemApiHook)
IFSMgr_Service  (IFSMgr_RunScheduledEvents)
IFSMgr_Service	(IFSMgr_CheckDelResource)
IFSMgr_Service	(IFSMgr_Win32GetVMCurdir)
IFSMgr_Service	(IFSMgr_SetupFailedConnection)
IFSMgr_Service	(_GetMappedErr)
IFSMgr_Service	(ShortToLossyFcb)
IFSMgr_Service	(IFSMgr_GetLockState)
IFSMgr_Service	(BcsToBcs)
IFSMgr_Service	(IFSMgr_SetLoopback)
IFSMgr_Service	(IFSMgr_ClearLoopback)
IFSMgr_Service	(IFSMgr_ParseOneElement)
IFSMgr_Service	(BcsToBcsUpper)
End_Service_Table(IFSMGR)


//----------------------------------------------------------------------
//
// BlockDev service definitions
//
//----------------------------------------------------------------------
//
// Again, vtoolsd does not define these service identifiers. Vtoolsd does
// however have library wrappers of the same names, so we modify these
// names with a leading underscore. This is taken from the win 3.1 DDK. 
//
#define BlockDev_Service Declare_Service
Begin_Service_Table(BLOCKDEV)

BlockDev_Service    (_BlockDev_Get_Version)
BlockDev_Service    (_BlockDev_Register_Device)
BlockDev_Service    (_BlockDev_Find_Int13_Drive)
BlockDev_Service    (_BlockDev_Get_Device_List)
BlockDev_Service    (_BlockDev_Send_Command)
BlockDev_Service    (_BlockDev_Command_Complete)
BlockDev_Service    (_BlockDev_Synchronous_Command)

End_Service_Table(BLOCKDEV)





