///////////////////////////////////////////////////////////////
// Program: LoadImag.java
//  Author: Anil Hemrajani
//          anil@patriot.net
//          http://www.patriot.net/users/anil/
// Purpose: Loads an image inside a java.awt.Canvas object.
///////////////////////////////////////////////////////////////

import java.awt.Image;
import java.awt.Dimension;


//********************************************
//* This loads an image in a Canvas area which 
//* paints itself as necessary.
//********************************************
public class LoadImag extends java.awt.Canvas
{
   Image currImg;
   int width=32, height=32;

   public LoadImag(Image imageFile)
   {
       currImg=imageFile;
   }

   public LoadImag(Image imageFile, int w, int h)
   {
       currImg=imageFile;
       width=w;
       height=h;
   }

   public void paint(java.awt.Graphics g)
   {
       if (currImg != null)
           g.drawImage(currImg,
                       0, 0, width, height,
                       getBackground(), this);
   }

   public Dimension minimumSize()
   {
       return new Dimension(width, height);
   }

   public Dimension preferredSize()
   {
       return minimumSize();
   }
}

