#!/usr/bin/perl
#
#  Minishop1.cgi
#
#  A simple shopping cart CGI script
#  written Chris Baron
#  for Dr. Dobb's Journal
#  5/15/96
#
#  This script uses the HIDDEN attribute for
#  a text field to store the data in
#  the shopping cart
#  This data is updated each time the user
#  executes the script
#
#  This script uses the cgi-lib.pl v2.4 utility module
#  by Steven Brenner (S.E.Brenner@bioc.cam.ac.uk)
#  http://www.bio.cam.ac.uk/cgi-lib/
#

# tells Perl to use the cgi-lib.pl module
require 'cgi-lib.pl';

# our script name
$self = $ENV{'SCRIPT_NAME'};

# initialize the catalog.  For a real system you would 
# want to store in a database for ease of maintenance
# and flexibility to add and delete new products
#
# the format of the catalog is --
# part#, title:price:num-disks:weight
%catalog = (
	'cd001', 'Algorithms and Data Structures:59.95:1:0.1',
	'cd002', 'WWW Toolkit:29.95:1:.1',
	'cd003', 'Graphics Programming Books:69.95:1:0.1',
	'cd004', q/Dr. Dobb's on CD-ROM:79.95:2:0.2/,
	'cd005', '386BSD Reference:99.00:1:0.1',
	'cd006', 'Alternative Languages:49.95:1:0.1');


# MAIN routine

 MAIN: 
{
# Read in all the variables set by the form
if (&ReadParse(*form)) { # if true there were parameters
		$to_do = $form{'action'}; # fetch the command
} 
else {   # called with no parameters i.e. initial call
    $to_do = 'display'; #just show the catalog
}


# load the cart data into an array for use if any
&get_state;

# the Perl equivalent of a switch statement
# to display the proper page based on which
# submit button was pressed or action parameter was passed

switch: {
	if (($to_do eq 'display') || ($to_do eq 'Return')) { 
		&show_cat; last switch; }
	if ($to_do eq 'showitem') {	&show_item_page($form{'page'}); last switch; }
	if ($to_do eq 'Show Cart') {	&show_cart; last switch; }
	if ($to_do eq 'Buy/Update') {	&add_item($form{'item'}, $form{'num'}); 
		&show_cart; last switch; }
	if ($to_do eq 'Check Out') { &check_out; last switch; }
	if ($to_do eq 'Empty Cart') { &empty_cart; &show_cat; last switch; }
	&CgiError('Boo Boo', 'Bad Command none matched', &PrintVariables(%form));
}

} # end of MAIN

##################### State Subroutines #######################

# get_state
#
# here is where we fetch the state data from the hidden field
# and load it into an associative array for use
sub get_state {

	%cart_data = split(":", $form{'cartdata'});

}

# maintain_state
#
# Here is where the hidden cart data is stored into the form
# the hidden type creates a string for use in an input field with a
# tag like <INPUT TYPE="HIDDEN" NAME="cartdata" VALUE="$cart_out">
sub maintain_state {

	if (%cart_data) { 
		$cart_out = join(":", %cart_data);
	}
}


# add_item
#
# add an item to the shopping cart
# the state consists of an array
# of part numbers with a non-zero quantity
# a quantity of zero means delete it
sub add_item {
	local ($item, $num) = @_;

	if ($num == 0) { delete $cart_data{$item} }
	else { $cart_data{$item} = $num; }  #this does a simple overwrite

}

# empty_cart
#
# empty out the cart by simply undefing the %cart_data array
sub empty_cart {

	undef %cart_data;
}

# print_type
#
# Prints out the magic "Content-Type: text/html" line
sub print_type {
	print "Content-Type: text/html\n\n";
}



##################### Display Subroutines ######################

# show_cat
#
# show the catalog index page
sub show_cat {


	&print_type;  # the content-type: line
	&maintain_state;    # this generates the state information

	print &HtmlTop("Minishop On-Line CD-ROM Catalog");
	print "<P>This catalog uses the type=HIDDEN form method of \n";
	print "maintaining state information between pages.";
  	print "<P>Please click on an item to view more detail or to order it.\n";
	print "<P><CENTER><TABLE BORDER>\n";
	print "<TR><TH>Current CDs In Stock</TH></TR>\n";

	# sort for display
	foreach $item (sort keys(%catalog)) { 
		($name, $price, $num_cd, $wt) = split(':',$catalog{$item});
		print qq(<TR><TD>);
		print qq(<A HREF="$self?action=showitem&page=$item&cartdata=$cart_out">);
		print "$name</A></TD></TR>\n";
	}

	print "</TABLE></CENTER>\n";
 
	print qq(<P><CENTER><FORM ACTION="$self" METHOD="POST">);
	print qq(<INPUT NAME="action" TYPE="SUBMIT" 
					VALUE="Show Cart" ALIGN=left>\n);
	print qq(<INPUT NAME="action" TYPE="SUBMIT" 
					VALUE="Empty Cart" ALIGN=center>\n);
	print qq(<INPUT NAME="action" TYPE="SUBMIT" 
					VALUE="Check Out" ALIGN=right>\n);

	print qq(<INPUT NAME="cartdata" TYPE="HIDDEN" VALUE="$cart_out">);

#	print &PrintVariables(%form); ######### debugging

	print "</FORM></CENTER></BODY></HTML>\n";
	
}

# show_item_page
#
# show the page for an individual item
sub show_item_page {
	local($item) = pop(@_);
	($name, $price, $num_cd, $wt) = split(':',$catalog{$item});

	&print_type;  # the content-type:.line
	&maintain_state;    # this generates the state information

	print &HtmlTop("Catalog Page for $name");

	print "<P>Here is where you would place the picture and ";
	print "description of this item";
	print "you would want to store the description in a database ";
	print "along with a reference to the graphic image etc.\n";

	print qq(<P><FORM ACTION="$self" METHOD="POST">);

	print qq(<CENTER><TABLE BORDER WIDTH="100%">\n);
	print "<TR><TH></TH><TH>Item</TH>";
	print "<TH>No. CDs</TH><TH>Price</TH></TR>\n";
	$val = ($cart_data{$item}) || 1;
	print qq(<TR><TD><INPUT NAME="num" TYPE="TEXT" VALUE="$val");
	print qq( COLS=2 SIZE="5"></TD>\n);
	print "<TD>$name</TD><TD>$num_cd</TD><TD>$price</TD>";
	print "</TR></TABLE>\n";

	print qq(<P><TABLE BORDER=0 WIDTH="100%"><TR>\n);
	print qq(<TD><INPUT NAME="action" TYPE="SUBMIT" 
					VALUE="Buy/Update"></TD>\n);
	print qq(<TD><INPUT NAME="action" TYPE="SUBMIT" 
					VALUE="Show Cart" ALIGN=left></TD>\n);
	print qq(<TD><INPUT NAME="action" TYPE="SUBMIT" 
					VALUE="Empty Cart" ALIGN=left></TD>\n);
	print qq(<TD><INPUT NAME="action" TYPE="SUBMIT" 
					VALUE="Check Out" ALIGN=left></TD>\n);
	print "</TR></TABLE>\n";
	print "</CENTER>";

	print qq(<INPUT NAME="cartdata" TYPE="HIDDEN" VALUE="$cart_out">);
	
#	print &PrintVariables(%form); ######### debugging

	print qq(<INPUT NAME="item" TYPE="HIDDEN" VALUE="$item">);


	print "</FORM>\n";
	print "</BODY></HTML>\n";

}

# show_cart
#
# display the entire cartfull of stuff

sub show_cart {

	&print_type;
	&maintain_state;    # this generates the state information

	print &HtmlTop("Your Shopping Cart");

	if (! keys %cart_data) { # shortcut if nothing in cart
		print "<P>Is empty.";
	}
	else {
	print "<P>Listed below is your current shopping cart\n";
	print "<UL>\n";
	print "<LI>Review the contents of your cart.\n";
	print "<LI>To delete an item ";
	print "click on the name and change the quantity to zero\n";
	print "<LI>To change the quantity click the item name\n";
	print "<LI>To complete your order click the 'Check Out' button.\n";
  print "</UL>\n";
	print "<P>\n";

	print qq(<CENTER><TABLE BORDER=1 WIDTH="100%" ALIGN=CENTER>\n);
	print "<TR><TH>Quantity</TH><TH>Item</TH>";
	print "<TH>Price</TH>\n";

	# we use the part number to relate the cart_data and the
	# catalog entries
	foreach $item (sort keys(%cart_data)) { # sort for display
		$num = $cart_data{$item};
		($name, $price, $num_cd, $wt) = split(':',$catalog{$item});
		print "<TR>";
		print "<TD>$num</TD>\n";
		print qq(<TD>);
		print qq(<A HREF="$self?action=showitem&page=$item&cartdata=$cart_out">);
		print "$name</A></TD>\n";
		print "<TD>$price</TD>\n";
		print "</TR>\n";
	}

	print "</TABLE></CENTER>\n";

	} # end of else

	print qq(<P><FORM ACTION="$self" METHOD="POST">);
	print qq(<P><TABLE BORDER=0 WIDTH="100%"><TR>\n);
	print qq(<TD><INPUT NAME="action" TYPE="SUBMIT" 
					VALUE="Return"></TD>\n);
	print qq(<TD><INPUT NAME="action" TYPE="SUBMIT" 
					VALUE="Empty Cart" ALIGN=left></TD>\n);
	print qq(<TD><INPUT NAME="action" TYPE="SUBMIT" 
					VALUE="Check Out" ALIGN=left></TD>\n);
	print "</TR></TABLE>\n";

	print qq(<INPUT NAME="cartdata" TYPE="HIDDEN" VALUE="$cart_out">);

#	print &PrintVariables(%form); ######### debugging

	print "</FORM>", &HtmlBot;
}


# check_out
#
# generate the order page
#
sub check_out {

	&print_type;
	&maintain_state;    # this generates the state information

	print &HtmlTop("Your Order");

	print "<P>Here is your order<P>Please review it.  If everything is OK\n";
	print "Then fill in the information below and click the 'Order' button\n";
	print "Your order will be on it's way in no time (literally).\n";

	print "<CENTER><TABLE BORDER>\n";
	print "<TR><TH>Item</TH><TH>Quantity</TH><TH>Price</TH><TH>Total</TH></TR>\n";
	
	foreach $item (sort keys(%cart_data)) { # sort for display
		$num = $cart_data{$item};
		($name, $price, $num_cd, $wt) = split(':', $catalog{$item});
		$sub_tot =  $num * $price;
		$weight += $num * $wt;
		$grand_tot += $sub_tot;
		print "<TR><TD>$name</TD><TD>$num</TD><TD>$price</TD>";
		print "<TD>", sprintf("%7.2f",$sub_tot), "</TD></TR>\n";
	}
	print "<TR><TD></TD><TD></TD>";
	print "<TH>Sub Total:</TH><TH>", sprintf("%7.2f",$grand_tot), "</TH></TR>\n";

	$shipping = $weight * 3;
	print "<TR><TD></TD><TD></TD>";
	print "<TH>Shipping</TH><TH>", sprintf("%7.2f",$shipping), "</TH></TR>\n";

	$tax = $grand_tot*0.085;
	print "<TR><TD></TD><TD></TD>";
	print "<TH>Tax:</TH><TH>", sprintf("%7.2f",$tax), "</TH></TR>\n";

	print "<TR><TD></TD><TD></TD>";
	print "<TH>Grand Total:</TH><TH>", sprintf("%7.2f",$grand_tot+$tax+$shipping);
	print "</TH></TR>\n";
	print "</CENTER></TABLE>";
	
	# A really ugly shipping information form
	#
	# In a production system you could read this data
	# from a registered user database and not require
	# the user in input his/her shipping and payment data
	# each time. This also increases security.

	print <<EndofForm
		<FORM ACTION="$self" METHOD="POST">
		<INPUT NAME="action" TYPE="SUBMIT" VALUE="Return">
		<INPUT NAME="action" TYPE="SUBMIT" VALUE="Empty Cart">
		<HR>
		Your Name: <INPUT NAME="name" TYPE="TEXT" COLS=30 SIZE="50"><BR>
		Street Address: <INPUT NAME="addr" TYPE="TEXT" COLS=50 SIZE="60"><BR>
		City: <INPUT NAME="city" TYPE="TEXT" COLS=15 SIZE="60"><BR>
		State: <INPUT NAME="state" TYPE="TEXT" COLS=2 SIZE="5">  
		Zip:  <INPUT NAME="zip" TYPE="TEXT" COLS=12 SIZE="12">  
		Country:  <INPUT NAME="country" TYPE="TEXT" COLS=12 SIZE="12">
		<CENTER><HR WIDTH="50%"></CENTER>
		Method of Payment:  Visa <INPUT NAME="pmt" TYPE="RADIO" VALUE="visa">
		Master Card <INPUT NAME="pmt" TYPE="RADIO" VALUE="nc">
		Discover <INPUT NAME="pmt" TYPE="RADIO" VALUE="dis"><BR>
		Card #: <INPUT NAME="card" TYPE="TEXT" COLS=15 SIZE="20">  
		Expiration: <INPUT NAME="exp" TYPE="TEXT" COLS=9 SIZE="20"><BR>
		<CENTER><HR WIDTH="50%"></CENTER>
		Shipping Method: <SELECT NAME="ship" VALUE="FedEx" SIZE= 1>
		<OPTION>U.S. Mail
		<OPTION>UPS Ground
		<OPTION>UPS Air
		<OPTION>FedEx
		</SELECT>
		<P><INPUT  NAME="action" TYPE="SUBMIT" VALUE="Send Order">  
		<INPUT  TYPE="RESET">

		<INPUT NAME="cartdata" TYPE="HIDDEN" VALUE="$cart_out">
		
		</FORM>
EndofForm
}


#eof Minishop.cgi shopping cart demo
