package COM.roguewave.jchat;
import java.util.*;
/**
 * The Dispatcher abstract class.  Dispatcher must be subclassed and the abstract
 * methods must be implemented before it can be instantiated.
 * <P>
 * The Dispatcher class represents a class which keeps track of multiple socket
 * Connections.  The processCommandSet should be overridden to provide a means
 * of receiving a command set from a Connection and then notifying the necessary
 * objects that are added to the Dispatcher through the addObjectToNotify method.
 * </P>
 *
 * @see     COM.roguewave.jchat.Connection
 *
 * @version 1.0  96 April 4
 * @author  Eldon J. Metz
 */
public abstract class Dispatcher extends Thread {	
  protected Hashtable connections_;
  
  /**
   * Creates a Dispatcher.
   */
  public Dispatcher() {
    connections_ = new Hashtable();
  }

  /**
   * Add a Connection to the Dispatcher.
   */
  public synchronized void addConnection ( Connection aConnection ) {
	connections_.put(aConnection.getUser(), aConnection);
  }

  /**
   * Add a notifier object to the dispatcher.  This method must be overridden and
   * implemented by a subclass.
   */
  public abstract synchronized void addObjectToNotify (String index, Object aObject);

  /**
   * Process a command  This method must be overridden and implemented by a subclass.
   */
  public abstract synchronized void processCommand( String[] command );
}
