package COM.roguewave.jchat;
import java.util.*;
/**
 * The Forum class.
 * <P>
 * The Forum class represents an aggregation of Connections that are viewing group
 * conversations.
 * </P>
 *
 * @version 1.0  96 April 4
 * @author  Eldon J. Metz
 */
public class Forum {
  private Vector connections_;
  private String forumName_;
  
  /**
   * Creates a new Forumm with the specified forum name.
   */
  public Forum (String forumName) {
    connections_ = new Vector();
    forumName_ = forumName;
  }

  /**
   * Adds a Connection.
   */
  public void addConnection(Connection aConnection) {
    connections_.addElement(aConnection);
  }

  /**
   * Removes a Connection.
   */
  public void removeConnection(Connection aConnection) {
    connections_.removeElement(aConnection);
  }
  
  /**
   * Delivers the specified message to all the Connections that are currently
   * listening in on this Forum.
   */
  public void send(String[] command) {
    Enumeration connectionEnumeration = connections_.elements();

	while (connectionEnumeration.hasMoreElements()) {
	  Connection aConnection = (Connection) connectionEnumeration.nextElement();
	  aConnection.send(command);
	}
  }
}
