package COM.roguewave.jchat;
import java.util.*;
import java.awt.*;
/**
 * The ForumViewDispatcher class.
 *
 * <P>
 * The ForumViewDispatcher class implements a specialized Dispatcher for the JChat
 * client.  The ForumDispatcher maintains a list of ForumViewWindows that are updated
 * when an update command is received.
 * </P>
 *
 * @see     COM.roguewave.jchat.Dispatcher
 *
 * @version 1.0  96 April 4
 * @author  Eldon J. Metz
 */
public class ForumViewDispatcher extends Dispatcher {	
  private Hashtable forumviews_;
  
  /**
   * Creates a ForumViewDispatcher.
   */
  public ForumViewDispatcher() {
    super();
	forumviews_ = new Hashtable();
  }

  /**
   * Adds an object that should be notified when the "update" or "add" command
   * is processed.
   */
  public synchronized void addObjectToNotify( String forumName, Object aObject ) {
    forumviews_.put(forumName, aObject);
  }

  /**
   * Process a command request.  For the ForumViewDispatcher, the following commands are
   * understood:
   * <PRE>
   *   post "forumname" "username" "message"
   *   add  "forumname" ""         ""
   * </PRE>
   */
  public synchronized void processCommand ( String[] command ) {
	 if (command[0].equals("post")) {
       ((TextArea)forumviews_.get(command[1])).appendText(command[2] + ": " + command[3] + "\n");
	 }
	 else if (command[0].equals("add")) {
	   ((List)forumviews_.get("_FORUM_LIST_")).addItem(command[1]);
	 }
  }
}
