//
// Client.java - JChat Client Applet
// Version - 1.0
// 4/29/96 - 7:49:34am
//
//
// zpb_begin Revisions
// zpb_end

import java.awt.*;
import java.util.*;
import java.applet.Applet;
import LogFontLayout;  // Fixed position layout based on font size
import COM.roguewave.jchat.*;
import java.net.Socket;

// zpb_begin UserImports
// zpb_end

class ForumListWindow extends Frame {

	private static Applet applet;
	Label pStatic1;
	List pListBox1;
	Button pNewForumButton, pCloseButton, pJoinButton;

	// Initial size in logical units
	Dimension initialSize = new Dimension(156, 214);
	Point initialLocation;
	// zpb_begin ForumListWindowUserVars
	Connection connection;
	Dispatcher dispatcher;
	private Vector     views_;
	// zpb_end

	ForumListWindow(Applet app, String title) {
		super(title);
		applet = app;


		// zpb_begin ForumListWindowConstructor_1
		views_ = new Vector();
		// zpb_end

		setBackground(Color.lightGray);
		setFont(new Font("Helvetica", Font.PLAIN, 12));
		LogFontLayout lfLayout = new LogFontLayout(this);
		setLayout(lfLayout);

		pListBox1 = new List(0, false);
		add("7 21 137 118", pListBox1);
		pStatic1 = new Label("List of Forums");
		add("6 4 55 12", pStatic1);
		pNewForumButton = new Button("New Forum...");
		add("81 149 54 14", pNewForumButton);
		pCloseButton = new Button("Close Connection");
		add("42 177 67 14", pCloseButton);
		pJoinButton = new Button("Join Forum...");
		add("13 149 54 14", pJoinButton);
		pJoinButton.disable();
		// zpb_begin ForumListWindowConstructor_2
		// zpb_end

		// Size and Position in logical units
		initialLocation = lfLayout.du(15, 28);
		
		pack();
		move(initialLocation.x, initialLocation.y);

		// zpb_begin ForumListWindowConstructor_3
		// zpb_end
	}

	public Dimension minimumSize() {
		// zpb_begin ForumListWindowMinimumSize
		// zpb_end
			
		LayoutManager layoutMgr = getLayout();
		if (layoutMgr instanceof LogFontLayout) {
			// Convert from logical units to absolute coordinates
			int w = initialSize.width;
			int h = initialSize.height;
			LogFontLayout layout = (LogFontLayout)layoutMgr;
			return new Dimension(layout.duX(w), layout.duY(h));
		}
		return new Dimension(initialSize);
	}

	public boolean handleEvent(Event e) {
		if (e.target == pListBox1 && e.id == Event.LIST_SELECT) {
			// zpb_begin ForumListWindowListBox1SelChange
			pJoinButton.enable();
			// zpb_end
			return false;
		}
		if (e.id == Event.WINDOW_DESTROY) {
			// zpb_begin ForumListWindowDestroy
			cleanup();
			// zpb_end
			dispose();
			return true;
		}

		// zpb_begin ForumListWindowHandleEvent
		if (e.target == pListBox1 && e.id == Event.LIST_DESELECT) {
			pJoinButton.disable();
			return false;
		}
		// zpb_end

		return super.handleEvent(e);
	}

	public boolean action(Event evt, Object obj) {
		if (evt.target == pNewForumButton) {
			NewForumDialog dNewForumDialog= new NewForumDialog(applet, this, "Create New Forum Dialog", true);
			// zpb_begin ForumListWindowNewForumButtonClickedShow
			dNewForumDialog.connection = connection;
			// zpb_end
			dNewForumDialog.show();
			// zpb_begin ForumListWindowNewForumButtonClicked
			// zpb_end
		}
		else if (evt.target == pCloseButton) {
			// zpb_begin ForumListWindowCloseButtonClicked
			cleanup();
			dispose();
			// zpb_end
		}
		else if (evt.target == pJoinButton) {
			ForumViewWindow wForumViewWindow= new ForumViewWindow(applet, "Forum Viewer");
			// zpb_begin ForumListWindowJoinButtonClickedShow
			views_.addElement(wForumViewWindow);
			wForumViewWindow.setTitle("Forum Viewer for " + pListBox1.getSelectedItem());
			wForumViewWindow.forumName = pListBox1.getSelectedItem();
			wForumViewWindow.connection = connection;
			dispatcher.addObjectToNotify(pListBox1.getSelectedItem(), wForumViewWindow.getForumArea());
			String[] command = new String[4];
			command[0] = "attach";
			command[1] = pListBox1.getSelectedItem();
			command[2] = connection.getUser();
			connection.send(command);

			// zpb_end
			wForumViewWindow.show();
			// zpb_begin ForumListWindowJoinButtonClicked
			// zpb_end
		}

		// zpb_begin ForumListWindowAction
		// zpb_end

		return true;
	}


	// zpb_begin ForumListWindowUserMethods
	public synchronized void cleanup() {
	  Enumeration viewEnumeration = views_.elements();
	  while (viewEnumeration.hasMoreElements())
	    ((ForumViewWindow)viewEnumeration.nextElement()).cleanup();

	  String[] command = new String[4];
	  System.out.println("Cleaning up");
	  command[0] = "close";
	  command[2] = connection.getUser();
	  connection.send(command);
	  dispatcher.stop();
	  connection.close();
	  ((Client)applet).pConnectButton.enable();
	}
	// zpb_end
}
class ForumViewWindow extends Frame {

	private static Applet applet;
	TextField pPostMessageBox;
	TextArea pForumArea;
	Label pStatic1, pStatic3;
	Button pPostButton;

	// Initial size in logical units
	Dimension initialSize = new Dimension(313, 199);
	Point initialLocation;
	// zpb_begin ForumViewWindowUserVars
	String forumName = "";
	Connection connection;
	// zpb_end

	ForumViewWindow(Applet app, String title) {
		super(title);
		applet = app;

		// zpb_begin ForumViewWindowConstructor_1
		// zpb_end

		setBackground(Color.lightGray);
		setFont(new Font("Helvetica", Font.PLAIN, 12));
		LogFontLayout lfLayout = new LogFontLayout(this);
		setLayout(lfLayout);

		pForumArea = new TextArea("");
		add("7 23 295 76", pForumArea);
		pForumArea.setEditable(false);
		pPostMessageBox = new TextField("");
		add("6 129 297 14", pPostMessageBox);
		pStatic1 = new Label("Message:");
		add("6 113 47 12", pStatic1);
		pPostButton = new Button("Post Message");
		add("126 154 56 12", pPostButton);
		pStatic3 = new Label("Forum Contents:");
		add("6 7 62 12", pStatic3);
		MenuBar mbMenu1 = new MenuBar();
		MenuItem mi;
		Menu mOptions = new Menu("Options");
		mOptions.add(mi=new MenuItem("Exit"));
		mbMenu1.add(mOptions);
		this.setMenuBar(mbMenu1);
		// zpb_begin ForumViewWindowConstructor_2
		// zpb_end

		// Size and Position in logical units
		initialLocation = lfLayout.du(15, 28);
		
		pack();
		move(initialLocation.x, initialLocation.y);

		// zpb_begin ForumViewWindowConstructor_3
		// zpb_end
	}

	public Dimension minimumSize() {
		// zpb_begin ForumViewWindowMinimumSize
		// zpb_end
			
		LayoutManager layoutMgr = getLayout();
		if (layoutMgr instanceof LogFontLayout) {
			// Convert from logical units to absolute coordinates
			int w = initialSize.width;
			int h = initialSize.height;
			LogFontLayout layout = (LogFontLayout)layoutMgr;
			return new Dimension(layout.duX(w), layout.duY(h));
		}
		return new Dimension(initialSize);
	}

	public boolean handleEvent(Event e) {
		if (e.id == Event.WINDOW_DESTROY) {
			// zpb_begin ForumViewWindowDestroy
			cleanup();
			// zpb_end
			dispose();
			return true;
		}

		// zpb_begin ForumViewWindowHandleEvent
		// zpb_end

		return super.handleEvent(e);
	}

	public boolean action(Event evt, Object obj) {
		if (evt.target instanceof MenuItem) {
			String label = (String)obj;
			if (label.equals("Exit")) {
				// zpb_begin ForumViewWindowOptionsExitSelection
				cleanup();
				dispose();
				// zpb_end
			}

			return true;
		}

		if (evt.target == pPostButton) {
			// zpb_begin ForumViewWindowPostButtonClicked
			String[] command = new String[4];
			command[0] = "post";
			command[1] = forumName;
			command[2] = connection.getUser();
			command[3] = pPostMessageBox.getText();
			connection.send(command);
			pPostMessageBox.setText("");
			// zpb_end
		}

		// zpb_begin ForumViewWindowAction
		// zpb_end

		return true;
	}


	// zpb_begin ForumViewWindowUserMethods
	public TextArea getForumArea() {
	  return pForumArea;
	}

	public synchronized void cleanup() {
	  String[] command = new String[4];
	  System.out.println("Cleaning up");
	  command[0] = "detach";
	  command[1] = forumName;
	  command[2] = connection.getUser();
	  connection.send(command);
	}
	// zpb_end
}
class NewForumDialog extends Dialog {

	private static Applet applet;
	TextField pNewForumName;
	Label pStatic1;
	Button pOK, pCancel;

	// Initial size in logical units
	Dimension initialSize = new Dimension(198, 76);
	Point initialLocation;
	// zpb_begin NewForumDialogUserVars
	Connection connection;
	// zpb_end

	NewForumDialog(Applet app, Frame parent, String title, boolean modal) {
		super(parent, title, modal);
		applet = app;
		setResizable(false);

		// zpb_begin NewForumDialogConstructor_1
		// zpb_end

		setFont(new Font("Helvetica", Font.PLAIN, 12));
		LogFontLayout lfLayout = new LogFontLayout(this);
		setLayout(lfLayout);

		pOK = new Button("OK");
		add("53 47 39 17", pOK);
		pCancel = new Button("Cancel");
		add("105 47 39 17", pCancel);
		pStatic1 = new Label("Enter Name for New Forum:");
		add("8 6 125 12", pStatic1);
		pNewForumName = new TextField("");
		add("9 22 175 14", pNewForumName);
		// zpb_begin NewForumDialogConstructor_2
		// zpb_end

		// Size and Position in logical units
		initialLocation = lfLayout.du(15, 28);
		
		pack();
		move(initialLocation.x, initialLocation.y);

		// zpb_begin NewForumDialogConstructor_3
		// zpb_end
	}

	public Dimension minimumSize() {
		// zpb_begin NewForumDialogMinimumSize
		// zpb_end
			
		LayoutManager layoutMgr = getLayout();
		if (layoutMgr instanceof LogFontLayout) {
			// Convert from logical units to absolute coordinates
			int w = initialSize.width;
			int h = initialSize.height;
			LogFontLayout layout = (LogFontLayout)layoutMgr;
			return new Dimension(layout.duX(w), layout.duY(h));
		}
		return new Dimension(initialSize);
	}

	public boolean handleEvent(Event e) {
		if (e.id == Event.WINDOW_DESTROY) {
			// zpb_begin NewForumDialogDestroy
			// zpb_end
			dispose();
			return true;
		}

		// zpb_begin NewForumDialogHandleEvent
		// zpb_end

		return super.handleEvent(e);
	}

	public boolean action(Event evt, Object obj) {
		if (evt.target == pOK) {
			// zpb_begin NewForumDialogOKClicked
			String[] command = new String[4];
			command[0] = "create";
			command[1] = pNewForumName.getText();
			connection.send(command);
			// zpb_end
			dispose();
			return true;
		}
		else if (evt.target == pCancel) {
			// zpb_begin NewForumDialogCancelClicked
			// zpb_end
			dispose();
			return true;
		}

		// zpb_begin NewForumDialogAction
		// zpb_end

		return true;
	}


	// zpb_begin NewForumDialogUserMethods
	// zpb_end
}
class ErrorDialog extends Dialog {

	private static Applet applet;
	Label pStatic1;
	Button pOK;

	// Initial size in logical units
	Dimension initialSize = new Dimension(159, 52);
	Point initialLocation;
	// zpb_begin ErrorDialogUserVars
	// zpb_end

	ErrorDialog(Applet app, Frame parent, String title, boolean modal) {
		super(parent, title, modal);
		applet = app;
		setResizable(false);

		// zpb_begin ErrorDialogConstructor_1
		// zpb_end

		setFont(new Font("Helvetica", Font.PLAIN, 12));
		LogFontLayout lfLayout = new LogFontLayout(this);
		setLayout(lfLayout);

		pOK = new Button("OK");
		add("62 28 35 17", pOK);
		pStatic1 = new Label("Connect Error:  Could not connect to Server.");
		add("7 9 145 12", pStatic1);
		// zpb_begin ErrorDialogConstructor_2
		// zpb_end

		// Size and Position in logical units
		initialLocation = lfLayout.du(15, 28);
		
		pack();
		move(initialLocation.x, initialLocation.y);

		// zpb_begin ErrorDialogConstructor_3
		// zpb_end
	}

	public Dimension minimumSize() {
		// zpb_begin ErrorDialogMinimumSize
		// zpb_end
			
		LayoutManager layoutMgr = getLayout();
		if (layoutMgr instanceof LogFontLayout) {
			// Convert from logical units to absolute coordinates
			int w = initialSize.width;
			int h = initialSize.height;
			LogFontLayout layout = (LogFontLayout)layoutMgr;
			return new Dimension(layout.duX(w), layout.duY(h));
		}
		return new Dimension(initialSize);
	}

	public boolean handleEvent(Event e) {
		if (e.id == Event.WINDOW_DESTROY) {
			// zpb_begin ErrorDialogDestroy
			// zpb_end
			dispose();
			return true;
		}

		// zpb_begin ErrorDialogHandleEvent
		// zpb_end

		return super.handleEvent(e);
	}

	public boolean action(Event evt, Object obj) {
		if (evt.target == pOK) {
			// zpb_begin ErrorDialogOKClicked
			// zpb_end
			dispose();
			return true;
		}

		// zpb_begin ErrorDialogAction
		// zpb_end

		return true;
	}


	// zpb_begin ErrorDialogUserMethods
	// zpb_end
}
class MainBitmap1 extends Canvas {
	private static Applet applet;
	Image theImage;
	int	imgw = -1;
	int	imgh = -1;

	// zpb_begin MainBitmap1UserVars
	// zpb_end

	public MainBitmap1(Applet app) {
		applet = app;
		if (applet != null)
			theImage = applet.getImage(applet.getDocumentBase(), "images/jchat.gif");
		else
			theImage = Toolkit.getDefaultToolkit().getImage("images/jchat.gif");

		// zpb_begin MainBitmap1Constructor
		// zpb_end
	}
	public void paint(Graphics g) {
		Dimension d = size();

		// zpb_begin MainBitmap1Paint
		// zpb_end

		if (imgw < 0) {
			imgw = theImage.getWidth(this);
			imgh = theImage.getHeight(this);
			if (imgw < 0 || imgh < 0) {
				return;
			}
		}
		g.drawImage(theImage, 0, 0, this);

		// zpb_begin MainBitmap1Paint_2
		// zpb_end
	}

    static long updateRate = 100;

    public synchronized boolean imageUpdate(Image img, int infoflags,
		int x, int y, int w, int h) {

		// zpb_begin MainBitmap1ImageUpdate
		// zpb_end

		boolean ret = true;
		boolean dopaint = false;
		long updatetime = 0;
		if ((infoflags & WIDTH) != 0) {
			imgw = w;
			dopaint = true;
		}
		if ((infoflags & HEIGHT) != 0) {
			imgh = h;
			dopaint = true;
		}
		if ((infoflags & (FRAMEBITS | ALLBITS)) != 0) {
			dopaint = true;
			ret = false;
		} else if ((infoflags & SOMEBITS) != 0) {
			dopaint = true;
			updatetime = updateRate;
		}
		if ((infoflags & ERROR) != 0) {
			ret = false;
		}
		if (dopaint) {
			// zpb_begin MainBitmap1ImageUpdate_2
			// zpb_end
			repaint(updatetime);
		}
		return ret;
    }

	// zpb_begin MainBitmap1UserMethods
	// zpb_end
}

public
class Client extends Applet {

	private static Applet applet;
	TextField pUserName;
	Label pStatic1;
	Button pConnectButton;
	MainBitmap1 pBitmap1;

	// Initial size in logical units
	Dimension initialSize = new Dimension(228, 148);
	// zpb_begin MainUserVars
            final static int DEFAULT_SERVER_PORT_NUM = 6600;
	// zpb_end

	public
	void init() {
		applet = this;

		// zpb_begin AppletInit
		// zpb_end

		setBackground(Color.lightGray);
		setFont(new Font("Helvetica", Font.PLAIN, 12));
		LogFontLayout lfLayout = new LogFontLayout(this);
		setLayout(lfLayout);

		pStatic1 = new Label("Enter your name:");
		add("9 70 83 12", pStatic1);
		pUserName = new TextField("");
		add("9 84 202 14", pUserName);
		pConnectButton = new Button("Connect...");
		add("93 108 37 12", pConnectButton);
		pBitmap1 = new MainBitmap1(applet);
		add("9 6 a360 a110", pBitmap1);

		// zpb_begin MainConstructor_2
		// zpb_end

		// Size in logical units
		resize(getLayout().preferredLayoutSize(this));

		// zpb_begin MainConstructor_3
		// zpb_end
	}

	public Dimension minimumSize() {
		// zpb_begin MainMinimumSize
		// zpb_end
			
		LayoutManager layoutMgr = getLayout();
		if (layoutMgr instanceof LogFontLayout) {
			// Convert from logical units to absolute coordinates
			int w = initialSize.width;
			int h = initialSize.height;
			LogFontLayout layout = (LogFontLayout)layoutMgr;
			return new Dimension(layout.duX(w), layout.duY(h));
		}
		return new Dimension(initialSize);
	}

	public boolean handleEvent(Event e) {

		// zpb_begin MainHandleEvent
		// zpb_end

		return super.handleEvent(e);
	}

	public Frame getFrame(Container c) {
		// zpb_begin AppletGetFrame
		// zpb_end
		if (c instanceof Frame || c == null)
			return((Frame)c);
		  else
			return(getFrame(c.getParent()));
	}

	public boolean action(Event evt, Object obj) {
		if (evt.target == pConnectButton) {
			ForumListWindow wForumListWindow= new ForumListWindow(applet, "Forums List");
			// zpb_begin MainConnectButtonClickedShow
			Socket aSocket = null;
			try {
		  	  aSocket = new Socket(applet.getCodeBase().getHost(), 6600);
			} catch (Exception e) {
			  ErrorDialog eDialog =new ErrorDialog(applet, null, "Error Dialog", true);			
			  eDialog.show();
			  return true;
			}
			pConnectButton.disable();
			ForumViewDispatcher aDispatcher = new ForumViewDispatcher();
			Connection aConnection = new Connection(aSocket, aDispatcher);
			aConnection.setClient(pUserName.getText());
			aDispatcher.addConnection(aConnection);
			aDispatcher.addObjectToNotify("_FORUM_LIST_", wForumListWindow.pListBox1);
			wForumListWindow.connection = aConnection;
			wForumListWindow.dispatcher = aDispatcher;
			// zpb_end
			wForumListWindow.show();
			// zpb_begin MainConnectButtonClicked
			// zpb_end
		}

		// zpb_begin MainAction
		// zpb_end

		return true;
	}


	// zpb_begin MainAppletUserMethods
	// zpb_end
}

// zpb_begin UserClasses
// zpb_end
