//
// LogFontLayout.java - Layout manager for positioning based on logical 
// units derived from the selected font. It allows layouts to look the 
// same regardless of the user's screen resolution. This layout also 
// supports the use of absolute coordinates that are not scaled based on
// the font. Prefix coordinates with the the letter 'a' to use absolute 
// positioning.
//
import java.awt.*;
import java.util.*;

public class LogFontLayout implements LayoutManager {
	int _dux=0, _duy=0;
	Container dad;
	Vector comps=new Vector();
	Vector locs=new Vector();
	static Font defaultfont = new Font("Dialog", Font.PLAIN, 12);

	protected static Rectangle rr;
	protected static final String 
		aveChString="ABCDEFGHIJLKMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
	
	public Point du(int x, int y) {
		return new Point(duX(x), duY(y));
	}

	protected int duX(int n) {
		int _x=n;
		long tmpL = _dux;
		if (_dux == 0) {
			FontMetrics fm;
			if (dad.getFont() != null)
				fm = dad.getFontMetrics(dad.getFont());
			else
				fm = dad.getFontMetrics(defaultfont);

			if (fm != null){
				long tExtents = (long)fm.stringWidth(aveChString);
				tmpL = tExtents/52l;
				if (tExtents%52l >= 26l)
					 tmpL++;
				_dux = (int)tmpL;
			}
		}
		tmpL *= (long)n;
		_x = (int)(tmpL / 4l);
		if ((tmpL % 4l) >= 2l) 
			_x++;

		return _x;
	}
	protected int duY(int n) {
		int _y=n;
		long tmpL = _duy;
		if (_duy == 0) {
			FontMetrics fm;
			if (dad.getFont() != null)
				fm = dad.getFontMetrics(dad.getFont());
			else
				fm = dad.getFontMetrics(defaultfont);
			tmpL = (long)fm.getHeight()*(long)n;
		}
		_y= (int)(tmpL/8l);
		if ((tmpL%8l) >= 4l) 	
			_y++;

		return _y;
	}

    public LogFontLayout(Container theDad) {
		dad=theDad;
    }

    public void addLayoutComponent(String du, Component co) {
		comps.addElement(co);
		locs.addElement(du);
	}

    public void removeLayoutComponent(Component co) {
		int i = comps.indexOf(co);
		if (i >= 0) {
			comps.removeElementAt(i);
			locs.removeElementAt(i);
		}
    }

    public Dimension minimumLayoutSize(Container c) {
		Dimension dim = new Dimension(0, 0);
		Insets insets = c.insets();
		dim.width += insets.left + insets.right;
		dim.height += insets.top + insets.bottom;
		return dim;
    }
    
    public Dimension preferredLayoutSize(Container c) {
		Dimension dim = c.minimumSize();
		Insets insets = c.insets();
		dim.width += insets.left + insets.right;
		dim.height += insets.top + insets.bottom;

		return dim;
    }

    public void layoutContainer(Container c) {
		Insets insets = c.insets();
		int top = insets.top;
		int left = insets.left;
		Dimension dim = new Dimension();

		int np=comps.size();
		for (int i=0;i<np;i++) {
			Component co=(Component)comps.elementAt(i);
			String du=(String)locs.elementAt(i);

			int val[], w, h;
			val=new int[5];
			String str;

			String tok=" ,";
			StringTokenizer st=new StringTokenizer(du,tok);
			for (int j=0;st.hasMoreTokens() && j<4;j++) {
				str=st.nextToken();
				if (str.charAt(0) == 'a') 
					val[j] = Integer.valueOf(str.substring(1)).intValue(); // Absolute coord
				else 
					if (j == 0 || j == 2)
						val[j] = duX(Integer.valueOf(str).intValue()); // Logical X unit
					else
						val[j] = duY(Integer.valueOf(str).intValue()); // Logical Y unit
			}

			// TextArea's minimum size is too large
			if (co instanceof TextArea) {
				dim.width = val[2];
				dim.height = val[3];
			} else {
				dim.width = Math.max(val[2], co.minimumSize().width);
				dim.height = Math.max(val[3], co.minimumSize().height);
			}

			co.reshape(left+val[0],top+val[1],dim.width,dim.height);
		}
    }
    
    public String toString() {
		return getClass().getName();
    }
}
