package COM.roguewave.shade;
/**
 * The Server class.
 *
 * @see     COM.roguewave.shade.CommandDispatcher
 * @see     COM.roguewave.shade.Receptionist
 *
 * @version 1.0  96 May 09
 * @author  Eldon J. Metz
 */
public class Server  {
  final static int DEFAULT_PORT_NUM = 6600;
  static int portNumber;
  
  /**
   * Run the server.  The first argurment passed to this program will be an
   * integer that specifies the port number.  If this argument is ommitted,
   * a default port number of 6600 will be used.
   */
  public static void main (String args[]) {
    try {
	  portNumber = Integer.valueOf(args[0]).intValue();
	} 
	catch (ArrayIndexOutOfBoundsException e) {
	  portNumber = DEFAULT_PORT_NUM;
	}

	// Create the forum dispatcher and tell it to get to work
	ForumDispatcher theDispatcher = new ForumDispatcher();
	theDispatcher.setPriority(Thread.MAX_PRIORITY / 2 );
	theDispatcher.start();

	// Create the Receptionist and tell it to get to work
	Receptionist theReceptionist = new Receptionist(portNumber, theDispatcher);
	theReceptionist.setPriority(Thread.MAX_PRIORITY / 4);
	theReceptionist.start();
  }
}
