#include "integral.hpp"

#define PIOVER2 1.5707963267948966192313216916397514420985846996875e0L

// These macros define position of constants in the array of long doubles
// called pldConstArray in the Integral object (for these elliptic integrals).

#define M_POSITION 0
#define N_POSITION 1

// Bit positions used to figure out if we have enough data to compute
#define M_SUPPLIED 1
#define K_SUPPLIED 2
#define X_SUPPLIED 4  
                      
//////////////////////////////////////////////////////////////////////////////
// ************** An EllipticIntegral is a kind of Integral *************** //
//////////////////////////////////////////////////////////////////////////////
class EllipticIntegral : public Integral
{
//////////////////////////////////////////////////////////////////////////
// PUBLIC CLASS INFORMATION
//////////////////////////////////////////////////////////////////////////
public:
   //////////////////////////////////////////////////////////////////////////
   // Construction
   //////////////////////////////////////////////////////////////////////////
   EllipticIntegral::EllipticIntegral( void );

   //////////////////////////////////////////////////////////////////////////
   // Destruction
   //////////////////////////////////////////////////////////////////////////
   ~EllipticIntegral( void );

   //////////////////////////////////////////////////////////////////////////
   // Inquiry Methods
   //////////////////////////////////////////////////////////////////////////
   char bOkToProcess( void );      // Return True if OK to do integration
   char bTrigonometric( void );     // Return True if Trigonometric interval
   long double ldGetK( void );     // Get the constant K for integration
   long double ldGetM( void );     // Get the constant M for integration
   long double ldGetPhi( void );   // Get the constant Phi for integration
   long double ldGetEllipticResult( void ); // Get the result of integration
   //////////////////////////////////////////////////////////////////////////
   // Modifier Methods
   //////////////////////////////////////////////////////////////////////////
   char bSetTrigonometric( char );        // Set flag for Trigonometric interval
   long double ldSetK( long double );     // Set the constant K for integration
   long double ldSetM( long double );     // Set the constant M for integration
   long double ldSetPhi( long double );   // Set the constant Phi for integration
   long double ldEvaluate( void );        // Evaluate the integral
//////////////////////////////////////////////////////////////////////////
// PRIVATE CLASS INFORMATION
//////////////////////////////////////////////////////////////////////////
private:
   //////////////////////////////////////////////////////////////////////////
   // Data Attributes
   //////////////////////////////////////////////////////////////////////////
   long double ldK;           // Constant for the integration
   long double ldM;           // Constant for the integration
   long double ldPhi;         // Constant for the integration
   char fOkToProcess;         // bitflag set indicates true if all test bits are on.
   char fTrigonometric;        // bitflag set indicates true if Trigonometric integral.
};

//////////////////////////////////////////////////////////////////////////////
// **** An EllipticIntegralOfThe1StKind is a kind of EllipticIntegral ***** //
//////////////////////////////////////////////////////////////////////////////
class EllipticIntegralOfThe1StKind : public EllipticIntegral
{
public:
   EllipticIntegralOfThe1StKind::EllipticIntegralOfThe1StKind(long double ldK, long double ldPhi);
   EllipticIntegralOfThe1StKind::~EllipticIntegralOfThe1StKind();  
   EllipticIntegralOfThe1StKind::Trigonometric( void );
   EllipticIntegralOfThe1StKind::Algebraic( void );
//////////////////////////////////////////////////////////////////////////
// PRIVATE CLASS INFORMATION
//////////////////////////////////////////////////////////////////////////
private:
   //////////////////////////////////////////////////////////////////////////
   // Data Attributes
   //////////////////////////////////////////////////////////////////////////
   long double pldConstArr[1]; // Constant array
};                 

//////////////////////////////////////////////////////////////////////////////
// **** An EllipticIntegralOfThe2ndKind is a kind of EllipticIntegral ***** //
//////////////////////////////////////////////////////////////////////////////
class EllipticIntegralOfThe2ndKind : public EllipticIntegral
{
public:
   EllipticIntegralOfThe2ndKind::EllipticIntegralOfThe2ndKind(long double ldK, long double ldPhi);
   EllipticIntegralOfThe2ndKind::~EllipticIntegralOfThe2ndKind();
   EllipticIntegralOfThe2ndKind::Trigonometric( void );
   EllipticIntegralOfThe2ndKind::Algebraic( void );
//////////////////////////////////////////////////////////////////////////
// PRIVATE CLASS INFORMATION
//////////////////////////////////////////////////////////////////////////
private:
   //////////////////////////////////////////////////////////////////////////
   // Data Attributes
   //////////////////////////////////////////////////////////////////////////
   long double pldConstArr[1]; // Constant array
};                                 

//////////////////////////////////////////////////////////////////////////////
// **** An EllipticIntegralOfThe3rdKind is a kind of EllipticIntegral ***** //
//////////////////////////////////////////////////////////////////////////////
class EllipticIntegralOfThe3rdKind : public EllipticIntegral
{
public:
   EllipticIntegralOfThe3rdKind::EllipticIntegralOfThe3rdKind(long double ldK, long double ldPhi, long double ldN);
   EllipticIntegralOfThe3rdKind::~EllipticIntegralOfThe3rdKind();
   EllipticIntegralOfThe3rdKind::Trigonometric( void );
   EllipticIntegralOfThe3rdKind::Algebraic( void );

   long double ldGetN( void );        // Get the constant N for integration
   long double ldSetN( long double ); // Set the constant N for integration
//////////////////////////////////////////////////////////////////////////
// PRIVATE CLASS INFORMATION
//////////////////////////////////////////////////////////////////////////
private:
   //////////////////////////////////////////////////////////////////////////
   // Data Attributes
   //////////////////////////////////////////////////////////////////////////
   long double ldN;            // Constant for the integration
   long double pldConstArr[2]; // Constant array
   char bNwasSupplied;         // We can't process until N is supplied
};

