#ifndef _INTEGRAL_INCLUDED_
#define  _INTEGRAL_INCLUDED_
#ifdef WINDOWS
#include <windows.h>
#define EXPORT __export
#else
#define CDECL __cdecl
#define TRUE 1
#define EXPORT
#endif
#ifndef NULL
#define NULL ((void *)0)
#endif

#ifdef WIN32
#define FAR
#else
#define FAR __far
#endif

typedef long double ( FAR CDECL * _ldIntegralFunction_t)(long double, const long double *);

class Integral
{
//////////////////////////////////////////////////////////////////////////
// PUBLIC CLASS INFORMATION
//////////////////////////////////////////////////////////////////////////
public:
   //////////////////////////////////////////////////////////////////////////
   // Construction
   //////////////////////////////////////////////////////////////////////////
   EXPORT Integral(   // Constructor requires no arguments.
   ); // This version performs no evaluations on construction

   EXPORT Integral(   // Constructor requires three arguments.
      long double ldX0, // Beginning of the interval to integrate.
      long double ldX1, // Ending of the interval to integrate.
      _ldIntegralFunction_t ldF // The derivative function to integrate.
   );
   EXPORT Integral(   // Constructor requires three arguments.
      long double ldX0, // Beginning of the interval to integrate.
      long double ldX1, // Ending of the interval to integrate.
      _ldIntegralFunction_t ldF, // The derivative function to integrate.
      long double *pldConst // Optional const array is supplied for this one.
   );
   //////////////////////////////////////////////////////////////////////////
   // Destruction
   //////////////////////////////////////////////////////////////////////////
   EXPORT ~Integral(); // Destructor

   //////////////////////////////////////////////////////////////////////////
   // Inquiry Methods
   //////////////////////////////////////////////////////////////////////////
   // Display the result of the integration
   void EXPORT vDisplayResultsToConsole();    // Display the results to the console
   long double EXPORT ldGetIntegralResult(); // Get the results of the integration
   long double EXPORT ldGetX0(); // Get the start of the interval of integration
   long double EXPORT ldGetX1(); // Get the end of the interval of integration


   //////////////////////////////////////////////////////////////////////////
   // Modifier Methods
   //////////////////////////////////////////////////////////////////////////
   // Set the Derivative Function
   void EXPORT vSetFprime( _ldIntegralFunction_t ldF );
   void EXPORT vSetX0( long double ldX0 ); // Set the start of the interval
   void EXPORT vSetX1( long double ldX1 ); // Set the end of the interval
   void EXPORT vSetConstArr( long double *pldConst ); // Set the optional constant array
   //////////////////////////////////////////////////////////////////////////
   // Special Modifier Method
   //////////////////////////////////////////////////////////////////////////
   void EXPORT Evaluate();   // Evaluate the integral
//////////////////////////////////////////////////////////////////////////
// PRIVATE CLASS INFORMATION
//////////////////////////////////////////////////////////////////////////
private:

//////////////////////////////////////////////////////////////////////////
// Data Attributes
//////////////////////////////////////////////////////////////////////////
   _ldIntegralFunction_t ldFprime; // Derivative Function.
   long double ldIntegralResult; // Result of the integration.
   long double ldX0; // Beginning of the interval to integrate.
   long double ldX1; // Ending of the interval to integrate.
   long double *pldConstArray; // Optional array of constants used by function.
};
#else

#endif

