
#include <stdio.h>
#include <math.h>
#include <dos.h>

#ifdef WINDOWS
#include <windows.h>
#else
#define CDECL __cdecl
#endif
#ifdef WIN32
#define FAR
#else
#define FAR __far
#endif
static const long double ldZero = 0.0e0L;
static const long double ldOne  = 1.0e0L;
static const long double ldTwo  = 2.0e0L;

long double FAR CDECL e( long double ldX, long double *pldNull )
{
   /* Component of derivative of erf(x) [over 0..t] */
   /* "Handbook of Mathematical Functions", Abramowitz & Stegun, p297, 7.1.1 */
   if (ldX == ldZero)
      return ldOne;
   else
      return expl(-ldX*ldX);
}

long double FAR CDECL l( long double ldX, long double *pldNull )
{  /* Derivative of log x [over 1..t] */
   return ldOne/ldX;
}

long double FAR CDECL a( long double ldX, long double *pldNull )
{
   /* Derivative of arcsin x [over 0..t] */
   /* "Handbook of Mathematical Functions", Abramowitz & Stegun, p79, 4.4.1 */
   return ldOne/sqrtl( ldOne - ldX*ldX );
}

#ifdef __cplusplus
extern "C" {
#endif
   extern  long double erfl(long double x);
#ifdef __cplusplus
}
#endif

#include "integral.hpp"
#include "elliptic.hpp"
#define TWOOVERSQRTPI 1.1283791670955125738961589031215452e0L
#define PIOVERFOUR    7.8539816339744830961566084581987572e-1L
#define PI 3.1415926535897932384626433832795028841971693993751e0L

inline long double ldRadians( long double ldDegrees )
{
   return ldDegrees*.017453292519943295769236907684886127134428718885417e0L;
}
int main( int argc, char **argv )
{
   Integral LogOf2( ldOne, ldTwo, ( _ldIntegralFunction_t )  l );
   printf( "Integrated Log( 2.0 )   = %.20Lf\n", LogOf2.ldGetIntegralResult() );
   printf( "Lib Function logl( 2.0 )= %.20Lf\n", logl( ldTwo ) );
   puts( " Correct answer is:       0.69314718055994530941723212145817656807550013436025\n" );

   Integral LogOf200( ldOne, 200.0e0L, ( _ldIntegralFunction_t )  l );
   printf( "Integrated Log( 200 )   = %.20Lf\n", LogOf200.ldGetIntegralResult() );
   printf( "Lib function logl( 200 )= %.20Lf\n", logl( 200.0e0L ) );
   puts( " Correct answer is:       5.2983173665480366774532150308269049832777031116178\n" );

   Integral Arcsin( ldZero, 0.5e0L, ( _ldIntegralFunction_t )  a );
   printf( "Integrated Asin(1/2)    = %.20Lf\n", Arcsin.ldGetIntegralResult() );
   printf( "Lib function asinl(1/2) = %.20Lf\n", asinl( 0.5e0L ) );
   puts( " Correct answer is pi/6:  0.52359877559829887307710723054658381403286156656251\n" );

   Integral Erf( ldZero, ldOne, ( _ldIntegralFunction_t )  e );
   printf( "Integrated Erf( 1.0 )      = %.20Lf\n", TWOOVERSQRTPI*Erf.ldGetIntegralResult() );

   EllipticIntegralOfThe1StKind E1( sinl( PIOVERFOUR ),  PIOVERFOUR );
   printf("Elliptic Integral of the First Kind interval (Algebraic):\n   (sin(pi/4), pi/4) = %.20Lf\n",
   E1.ldGetEllipticResult() );

   E1.Trigonometric();
   E1.ldEvaluate();
   printf("Elliptic Integral of the First Kind interval (Trigonometric):\n   (sin(pi/4), pi/4) = %.20Lf\n",
   E1.ldGetEllipticResult() );

   EllipticIntegralOfThe2ndKind E2( sinl( PIOVERFOUR ),  PIOVERFOUR );
   printf("Elliptic Integral of the Second Kind interval (Algebraic):\n   (sin(pi/4), pi/4) = %.20Lf\n",
   E2.ldGetEllipticResult() );

   E2.Trigonometric();
   E2.ldEvaluate();
   printf("Elliptic Integral of the Second Kind interval (Trigonometric):\n   (sin(pi/4), pi/4) = %.20Lf\n",
   E2.ldGetEllipticResult() );


   EllipticIntegralOfThe3rdKind E3( sinl( PIOVERFOUR ),  PIOVERFOUR, 0.5e0L );
   printf("Elliptic Integral of the Third Kind interval (Algebraic):\n   (k=sin(pi/4), phi=pi/4, n=0.5) = %.20Lf\n",
   E3.ldGetEllipticResult() );

   E3.Trigonometric();
   E3.ldEvaluate();
   printf("Elliptic Integral of the Third Kind interval (Trigonometric):\n   (k=sin(pi/4), phi=pi/4, n=0.5) = %.20Lf\n",
   E3.ldGetEllipticResult() );
#ifdef ZZZZZZZ
   puts("TABLES TABLES TABLES TABLES");
   long double ldK;
   long double ldPhi;
   long double ldN;
   puts("Etype            phi  K                       Result                  Alpha");
   puts("--------------------  ----------------------  ----------------------  -----");

   for (ldK = 1.; ldK <= 89.; ldK = ldK + 1.)
      for (ldPhi = 1.; ldPhi <= 89.; ldPhi= ldPhi + 1.)
      {
         E1.ldSetPhi( ldRadians( ldPhi ) );
         E1.ldSetK( sinl( ldRadians( ldK ) ) );
         E2.ldSetPhi( ldRadians( ldPhi ) );
         E2.ldSetK( sinl( ldRadians( ldK ) ) );
         E3.ldSetPhi( ldRadians( ldPhi ) );
         E3.ldSetK( sinl( ldRadians( ldK ) ) );
         E1.Algebraic();
         E2.Algebraic();
         E3.Algebraic();
         printf("1st:Algebraic,     %.0Lf, %.20Lf, %.20Lf, %.0Lf\n", ldPhi, E1.ldGetK(), E1.ldGetEllipticResult(), ldK );
         E1.Trigonometric();
         E1.ldEvaluate();
         printf("1st:Trigonometric, %.0Lf, %.20Lf, %.20Lf, %.0Lf\n", ldPhi, E1.ldGetK(), E1.ldGetEllipticResult(), ldK );


         printf("2nd:Algebraic,     %.0Lf, %.20Lf, %.20Lf, %.0Lf\n", ldPhi, E2.ldGetK(), E2.ldGetEllipticResult(), ldK );
         E2.Trigonometric();
         E2.ldEvaluate();
         printf("2nd:Trigonometric, %.0Lf, %.20Lf, %.20Lf, %.0Lf\n", ldPhi, E2.ldGetK(), E2.ldGetEllipticResult(), ldK );


         puts("Etype            phi  K                       Result                  Alpha N");
         puts("--------------------  ----------------------  ----------------------  ----- ----------------------");
         for (ldN = .1; ldN < 1; ldN = ldN + .1)
         {
            E3.ldSetN( ldN );
            E3.Algebraic();
            E3.ldEvaluate();
            printf("3rd:Algebraic,     %.0Lf, %.20Lf, %.20Lf, %.0Lf,    %.20Lf\n", ldPhi, E3.ldGetK(), E3.ldGetEllipticResult(), ldK, ldN );
            E3.Trigonometric();
            E3.ldEvaluate();
            printf("3rd:Trigonometric, %.0Lf, %.20Lf, %.20Lf, %.0Lf,    %.20Lf\n", ldPhi, E3.ldGetK(), E3.ldGetEllipticResult(), ldK, ldN );
         }

      }
   puts("E3( n  = 5.0e-001,");
   puts("phi = 7.85398163397448309628e-001,");
   puts("m   = 5.00000000000000000054e-001) = 9.19022739165205687802e-001,");
   puts("WHERE Alpha=K=7.85398163397448309628e-001.");
#endif
   return 0;
}


