// File: bkthread.hpp

#ifndef __BKTHREAD_HPP__
#define __BKTHREAD_HPP__

#include <somd.hh>

#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_WIN
#include <os2.h>

#include <ithread.hpp> // Thread Class

#include "TChat.hh"    // Our SOM Class Declaration
#include "TChat.h"     // Resource ID for Our Icon
#include "Useful.hpp"  // Some Useful Items for DSOM Work
#include "Chatroom.hh" // Declaration of the Chatroom DSOM Class

/**********************************************************************
 *  Class Definitions for Items Used to Talk to the Background Thread
 **********************************************************************/

/**************************************************
 * Abstract Base Class for Mailing Ptrs via a Queue
 **************************************************/
class TRequest {
public:
                  TRequest() { }
  virtual  ULONG  cmd() const = 0;
};

/**************************************************
 *  Queue-of-Ptrs-to-Objects via OS/2's DosQueues
 **************************************************/
class TQueue {
           HQUEUE    _handle; // Handle of Open OS/2 Queue
public:
                     TQueue(const char *name, BOOL createfirst = TRUE);
  virtual           ~TQueue();

           void      putMsg(TRequest *req);
           TRequest *getMsg(BOOL waitflag);
};

/**************************************************
 * Wrapper Class Around a Background Worker Thread
 **************************************************/
class BackThread : public IThreadFn { // Background Thread for DSOM Requests
           BOOL      _running;    // True if Thread is Alive
           BOOL      _wantStop;   // Indicator of Desire for Thread Stop
           Environment *__SOMEnv; // Ptr to Standard SOM Enviroment
           IThread   _reqThread;  // Background Thread Itself
           M_TChat  *_metaclass;  // Ptr to Owning Metaclass
           TQueue    _reqQueue;

  virtual  void      run();       // Background Thead Code Body

public: // Requests Supported by DSOM Background Thread
  enum { JOIN_REQUEST = 1, QUIT_REQUEST, POST_REQUEST };

public:
                     BackThread(M_TChat *metaclass);
  virtual           ~BackThread();

           BOOL      isRunning() const           { return _running; }
           void      queueRequest(TRequest *req) { _reqQueue.putMsg(req); }
           BOOL      stopService();
};

/**************************************************
 *   Wrapped Request to Join a Chatroom Session
 **************************************************/
class TJoinRequest : public TRequest {
           TChat    *chatobj;     // Ptr to Object on Whose Behalf We Act
           char     *roomName;    // Name of Chatroom We Wish to Join
           char     *userName;    // Alias We Wish to Use in Chatroom
public:
                     TJoinRequest(TChat      *client,
                                  const char *room,
                                  const char *asUser);
  virtual           ~TJoinRequest();

  virtual  ULONG       cmd()    const { return BackThread::JOIN_REQUEST; }
           TChat      *client() const { return chatobj;  }
           const char *room()   const { return roomName; }
           const char *user()   const { return userName; }
};

/**************************************************
 *   Wrapped Request to Exit a Chatroom Session
 **************************************************/
class TQuitRequest : public TRequest {
           TChat    *chatobj;     // Ptr to Object on Whose Behalf We Act
public:
                     TQuitRequest(TChat *client);
  virtual           ~TQuitRequest() { }

  virtual  ULONG     cmd()    const { return BackThread::QUIT_REQUEST; }
           TChat    *client() const { return chatobj; }
};

/**************************************************
 *  Wrapped Request to Post Text into a Chatroom
 **************************************************/
class TPostRequest : public TRequest { // Envelope Class for Sending Text
           TChat    *chatobj;     // Ptr to Object on Whose Behalf We Act
           char     *sometext;    // Text to Broadcast Inside the Chatroom
public:
                     TPostRequest(TChat *client, const char *text);
  virtual           ~TPostRequest() { delete sometext; }

  virtual  ULONG       cmd()    const { return BackThread::POST_REQUEST; }
           TChat      *client() const { return chatobj;  }
           const char *text()   const { return sometext; }
};

/**********************************************************************
 *
 **********************************************************************/
#endif

