// File: chatroom.hh

#ifndef __CHATROOM_HH__
#define __CHATROOM_HH__

#include <somd.hh>     // DSOM Declarations
#include <snglicls.hh> // SingleInstance SOM Metaclass

/**********************************************************************
 *                    Chatroom DSOM Server Class
 *
 * A single instance of the Chatroom class runs in a separate process
 * and serves DSOM requests from afar.  Its purpose is to allow clients
 * to register and then to send them echos of any keystrokes that other
 * clients send to the Chatroom.
 *
 * There are many areas of improvement, for tracking of clients, for
 * authentication, etc.  A chatroom-to-chatroom linking might be fun
 * to, for distributing the broadcast load over slow SLIP/PPP lines.
 *
 * There is NOTHING in this class that has to do with the Workplace
 * Shell.  It is a pure DSOM server.
 *
 **********************************************************************/

#pragma SOMAsDefault(on)
class Chatroom : public SOMDServer {
    #pragma SOMClassVersion(*, 1, 1)        // This is Version 1.1
    #pragma SOMClassName(*, "Chatroom")     // My Class Name is ...
    #pragma SOMNoMangling(*)                // Don't C++ Mangle My Symbols
    #pragma SOMCallStyle(IDL)               // Class is in New IDL Style
    #pragma SOMIDLPass(*, "Implementation-Begin", \
                          "dllname = \"chatroom.dll\";")
    #pragma SOMMetaClass(*, "SOMMSingleInstance")  // My Metaclass is...
    #pragma SOMAsDefault(pop)

public:
                       Chatroom();
    virtual           ~Chatroom();

    // Strictly speaking, the SOMIDLDecl #pragmas are not needed for
    // these methods since the Direct-to-SOM process correctly figures
    // out my intention (direction of parameter data flow).  I put them
    // here to show how it would be done if you needed to alter them.

            boolean    joinSession(SOMObject *obj, const char *userAlias);
    #pragma SOMIDLDecl(joinSession, \
        "boolean joinSession(in SOMObject p__arg1, in string p__arg2)")

            boolean    quitSession(SOMObject *obj);
    #pragma SOMIDLDecl(quitSession, \
        "boolean quitSession(in SOMObject p__arg1)")

            boolean    postSession(const char *postText);

    // Define Release Order for Introduced Methods (But Not Overrides)
    #pragma SOMReleaseOrder( \
                            "joinSession", \
                            "quitSession", \
                            "postSession")
};

/**********************************************************************
 *
 **********************************************************************/
#endif

