// File: chatview.hpp

#ifndef __CHATVIEW_HPP__
#define __CHATVIEW_HPP__

#include <iframe.hpp>   // Frame Window
#include <ititle.hpp>   // Title Bar
#include <imle.hpp>     // Multiline Editor
#include <isplitcv.hpp> // Split Canvas
#include <ikeyhdr.hpp>  // Keyboard Handler
#include <istattxt.hpp> // Static Text
#include <ithread.hpp>  // Thread

#include "TChat.hh"

/**********************************************************************
 *  Class Declarations for What You See When the Chat Object is Open
 **********************************************************************/
class ChatView;

/**************************************************
 *   Keystroke Handler for the Chat Input Window
 **************************************************/
class ChatInput : public IMultiLineEdit, public IKeyboardHandler {
            ChatView  *_host; // Ptr to Open View into Chat Session
public:
                       ChatInput(ChatView         *recv,
                                 unsigned long     id,
                                 IWindow          *parent,
                                 IWindow          *owner,
                                 const IRectangle& initial= IRectangle(),
                                 const Style&      style = defaultStyle() );

    virtual Boolean    virtualKeyPress(IKeyboardEvent& event);
    virtual Boolean    characterKeyPress(IKeyboardEvent& event);
};

/**************************************************
 * View into a Chat Session, Both Input and Output
 **************************************************/
class ChatView : public IFrameWindow, public IKeyboardHandler {
            TChat     *somObj;    // Ptr to WPS Object This View Represents
            ITitle     myTitle;   // Title Bar on This View
            USEITEM   *myUseItem; // Ptr to WPS USEITEM Record

            ISplitCanvas   chatArea;   // Dual-Pane Window Area
            IMultiLineEdit upperPane;  // Upper-Pane for Display-Only
            ChatInput      lowerPane;  // Lower-Pane for Broadcasting Keys
            IStaticText    statusArea; // Status Area for Connect Info
public:
                       ChatView(TChat *obj);
                      ~ChatView();

            int        viewID() { return TChat::VIEWID_CHATVIEW; }
            void       displayText(const char *str);
            void       emitText(const char *str);

            void       setState(short state);
            void       setStatus(const char *s = "")
                       { statusArea.setText(s); }
};

/**********************************************************************
 *
 **********************************************************************/
#endif

