// File: tchat.hh

#ifndef __TCHAT_HH__
#define __TCHAT_HH__

#include <os2.h>
#define INCL_WPCLASS
#include <pmwp.h>

class M_WPAbstract;
#pragma SOMClassName(M_WPAbstract,   "M_WPAbstract")

class M_WPObject;
#pragma SOMClassName(M_WPObject,     "M_WPObject")

#include <som.hh>
#include <WPObject.hh>
#include <WPAbs.hh>

/**********************************************************************
 *           Distributed-Chatroom Desktop Interface Class
 *
 * This class represents an icon on the OS/2 desktop that listens to
 * keystrokes posted into a remote 'chatroom' object.  When opened,
 * the keystrokes are displayed and any entered by the user are sent
 * to the 'chatroom' for broadcasting to others.
 *
 * If a keystroke comes in when the icon is closed, it changes shape
 * to alert you that people are talking.
 *
 * The possibilities for expansion are unlimited; sound effects,
 * graphic 'person speaking' icons, per-line input buffering, etc.
 *
 * NOTE: A similar class could be defined that did nothing but log
 * the conversation taking place, without any Workplace Shell work
 * at all.
 *
 **********************************************************************/
class BackThread;
class TRequest;
class Chatroom;

/**************************************************
 * Metaclass (NOT Parent) of TChat Abstract Object
 *  (The Real Runtime Class Itself ala Smalltalk)
 **************************************************/
#pragma SOMAsDefault(on)
class M_TChat : public M_WPAbstract { // Declares Class Methods
    #pragma SOMClassVersion(*, 1, 1)     // This is Version 1.1
    #pragma SOMClassName(*, "M_TChat")   // My Class Name is...
    #pragma SOMNoMangling(*)             // Don't C++ Mangle My Symbols
    #pragma SOMCallStyle(OIDL)           // WPS Classes are Old IDL Style
    #pragma SOMIDLPass(*, "Implementation-Begin", \
                          "dllname = \"tchat.dll\";")
    #pragma SOMAsDefault(pop)

    #pragma SOMIDLPass(*, "Begin", "#include \"wpabs.idl\"")

    typedef M_WPAbstract Parent;         // Convenient Ref in Code

    #pragma SOMIDLDecl(BackThread, "typedef SOMFOREIGN BackThread")
    #pragma SOMIDLPass(*, "Begin", \
        "#pragma modifier BackThread: impctx = C, length = 0;")

    #pragma SOMIDLDecl(TRequest, "typedef SOMFOREIGN TRequest")
    #pragma SOMIDLPass(*, "Begin", \
        "#pragma modifier TRequest: impctx = C, length = 0;")

            HPOINTER    hAttn;     // PM Handle of Need-Attention Icon
            HPOINTER    hNorm;     // PM Handle of Normal (Non-Attn) Icon
            ULONG       instances; // Count of Instances of This Class

            BackThread *requestThread; // Ptr to Background Thread Object
public:
                       M_TChat();
    virtual           ~M_TChat();

    virtual HPOINTER   queryNormalIcon();
    virtual HPOINTER   queryAttnIcon();

    virtual void       adjCount(int delta);

    virtual void       queueRequest(TRequest *req);
    #pragma SOMIDLDecl(queueRequest, \
                       "void queueRequest(in TRequest p__arg1)")

    // Overridden Workplace Shell Class Methods
    // (We Override More than Necessary to Monitor Things)

    virtual void       wpclsInitData();
    virtual void       wpclsUnInitData();
    virtual PSZ        wpclsQueryTitle();
    virtual ULONG      wpclsQueryDefaultView();
    virtual ULONG      wpclsQueryStyle();
    virtual BOOL       wpclsCreateDefaultTemplates(WPObject *aFolder);
    virtual ULONG      wpclsQueryIconData(PICONINFO pIconInfo);

    // Define Release Order for Introduced Methods (But Not Overrides)
    #pragma SOMReleaseOrder ( \
                             "queryNormalIcon", \
                             "queryAttnIcon",   \
                             "adjCount",        \
                             "queueRequest")
};

/**************************************************
 *        Class of TChat Abstract Object
 **************************************************/
#pragma SOMAsDefault(on)
class TChat : public WPAbstract { // Declares Instance Methods
    #pragma SOMClassVersion(*, 1, 1)     // This is Version 1.1
    #pragma SOMClassName(*, "TChat")     // My Class Name is...
    #pragma SOMNoMangling(*)             // Don't C++ Mangle My Symbols
    #pragma SOMCallStyle(OIDL)           // WPS Classes are Old IDL Style
    #pragma SOMIDLPass(*, "Implementation-Begin", \
                          "dllname = \"tchat.dll\";")
    #pragma SOMMetaClass(*, "M_TChat")   // My Metaclass is...
    #pragma SOMAsDefault(pop)

    typedef WPAbstract Parent;           // Convenient Ref in Code

            M_TChat   *myClass;
            char       myUserName[80];
            char       myRoomName[80];
            short      connectState;

            Chatroom  *roomObj;
    #pragma SOMIDLDecl(Chatroom, "typedef SOMFOREIGN Chatroom")
    #pragma SOMIDLPass(*, "Begin", "#pragma modifier Chatroom: impctx = C, length = 0;")

public: // Coordinate User-Assigned PM View IDs in a Central Place (Here)
            enum DesktopViews { // We Only Have One View Today
                       VIEWID_CHATVIEW = WPMENUID_USER
            };

            enum LinkStatus {
                       DISCONNECTED,  // Not Registered with a Chatroom
                       CONNECTING,    // Try to Get Registered...
                       CONNECTED,     // Registered with a Chatroom
                       DISCONNECTING  // Try to Get Unregistered...
            };

public:
                       TChat();
    virtual           ~TChat();

    // We declare the displayText() method as 'oneway' just to show it
    // can be done.  It means the Chatroom server just fires-and-forgets
    // with no hope of retry-upon-error, but it also runs faster.

    virtual void       displayText(const char *str);
    #pragma SOMIDLDecl(displayText, \
                      "oneway void displayText(in string p__arg1)")

    virtual boolean    emitText(const char *str);

    virtual const char *roomName() const { return myRoomName;  }
    virtual void       setRoomName(const char *name);

    virtual const char *userName() const { return myUserName; }
    virtual void       setUserName(const char *name);

    virtual void       reconnect(const char *room, const char *user);

    virtual Chatroom  *roomObject() const            { return roomObj; }
    virtual void       setRoomObject(Chatroom *room) { roomObj = room; }

    virtual ULONG      reallyDelete();
    virtual void       setState(short newstate);
    virtual short      state() const { return connectState; }

    // Overridden Workplace Shell Instance Methods
    // (We Override More than Necessary to Monitor Things)

    virtual BOOL       wpSetup(PSZ pszSetupString);
    virtual BOOL       wpModifyPopupMenu(HWND hwndMenu, HWND hwndCnr,
                                         ULONG iPosition);
    virtual HWND       wpOpen(HWND hwndCnr, ULONG ulView, ULONG param);
    virtual BOOL       wpMenuItemSelected(HWND hwndFrame, ULONG ulMenuId);
    virtual BOOL       wpSaveState();
    virtual BOOL       wpRestoreState(ULONG ulReserved);

    virtual void       wpObjectReady(ULONG ulCode, WPObject* refObject);
    virtual BOOL       wpSetupOnce(PSZ pszSetupString);
    virtual ULONG      wpDelete(ULONG fConfirmations);

    // Define Release Order for Introduced Methods (But Not Overrides)
    #pragma SOMReleaseOrder ( \
                             "displayText",   \
                             "emitText",      \
                             "roomName",      \
                             "userName",      \
                             "setState",      \
                             "state",         \
                             "roomObject",    \
                             "setRoomObject", \
                             "reallyDelete",  \
                             "setUserName",   \
                             "setRoomName",   \
                             "reconnect")
};

/**********************************************************************
 *
 **********************************************************************/
#endif

