// File: useful.hpp

#if !defined(__USEFUL_HPP__)
#define __USEFUL_HPP__

#include <som.hh>

/**********************************************************************
 *                   Useful SOM Utility Declarations
 **********************************************************************/

/*******************************
 * Global Constants and Macros
 *******************************/

/*******************************
 *    Structures and Types
 *******************************/
class SOMLocalEnv { // Create/Destroy a Local SOM Return-Value Environment
    Environment *__SOMEnv;
public:
    SOMLocalEnv() { __SOMEnv = SOM_CreateLocalEnvironment(); }
    ~SOMLocalEnv() { if (__SOMEnv) SOM_DestroyLocalEnvironment(__SOMEnv); }

    Environment *base() { return __SOMEnv; }

    BOOL check(const char *activity);
};

class SOMGlobalEnv { // Create/Destroy a Global SOM Return-Value Environment
public:
    SOMGlobalEnv() { __SOMEnv = SOM_CreateLocalEnvironment(); }
    ~SOMGlobalEnv() { if (__SOMEnv) SOM_DestroyLocalEnvironment(__SOMEnv); }

    Environment *base() { return __SOMEnv; }

    BOOL check(const char *activity);
};

/*******************************
 *     Function Prototypes
 *******************************/

/*******************************
 *      Global Variables
 *******************************/

/**********************************************************************
 *
 **********************************************************************/
#endif

