unit ShellDrp;

interface

uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, ExtCtrls;

type
	TDropFilesEvent =
		procedure(Sender : TObject; Files : TStringList;
      Location : TPoint) of Object;
	TShellDropPanel = class(TPanel)
  private
		FAccepting : Boolean;
		FOnDropFiles : TDropFilesEvent;
		procedure SetAccepting(b : Boolean);
		procedure DoDropFiles(Msg : TWMDropFiles);
		procedure WMDestroy(var Msg : TWMNoParams);
      message WM_DESTROY;
		procedure WMDropFiles(var Msg : TWMDropFiles);
      message WM_DROPFILES;
	protected
		procedure DropFiles(Files : TStringList;
      Location : TPoint); dynamic;
	published
		property Accepting : Boolean read FAccepting
      write SetAccepting;
		property OnDropFiles : TDropFilesEvent read FOnDropFiles
      write FOnDropFiles;
	end;

procedure Register;

implementation

uses ShellAPI;

procedure Register;
begin
	RegisterComponents('PSobolik', [TShellDropPanel]);
end;

procedure TShellDropPanel.SetAccepting(b : Boolean);
begin
	if b <> FAccepting then
	begin
		FAccepting := b;
		DragAcceptFiles(Handle, FAccepting);
	end;
end;

procedure TShellDropPanel.DropFiles(Files : TStringList;
  Location : TPoint);
begin
	if Assigned(FOnDropFiles) then
		FOnDropFiles(Self, Files, Location);
end;

procedure TShellDropPanel.WMDropFiles(
  var Msg : TWMDropFiles);
begin
	Inherited;
	DoDropFiles(Msg);
end;

procedure TShellDropPanel.DoDropFiles(Msg : TWMDropFiles);
type
	TStringBuffer = Record
		case Integer of
			0: (bCount : Byte; cArray : array[0..254] of Char;);
			1: (str : String);
	end;
var
	lstFiles : TStringList;
	pt : TPoint;
	wFileCt : Word;
	i : Integer;
	sb : TStringBuffer;
begin
  try
    if DragQueryPoint(Msg.Drop, pt) then
    {only accepts drop in client area}
    begin
      lstFiles := TStringList.Create;
      try
        wFileCt := DragQueryFile(Msg.Drop, $FFFF, Nil, 0);
        for i := 0 to wFileCt - 1 do
        begin
          sb.bCount := Byte(DragQueryFile(Msg.Drop, i,
            sb.cArray, sizeof(sb.cArray)));
          lstFiles.Add(sb.str);
        end;
        DropFiles(lstFiles, pt);
      finally
        lstFiles.Free;
      end;
    end;
  finally
  	DragFinish(Msg.Drop);
  end;
end;

procedure TShellDropPanel.WMDestroy(var Msg : TWMNoParams);
begin
	inherited;
	Accepting := False;
end;

end.


