/*
 *  print.c - code to handle printing a file.
 */

#include <stdio.h>
#include <string.h>
#include <windows.h>

#define BUFFER_SIZE 4096

int     PrintFile(char* PrinterName, char *Port,
            HWND Parent, char *Filename)
    {
    char    MsgBuf[128];
    char   *Buffer = new char[BUFFER_SIZE+1];

    if(Buffer == NULL)
        {
        MessageBox(Parent,
                        "Insufficient memory for file copy",
                             "PassThru", MB_OK|MB_ICONSTOP);
        return FALSE;
        }
    FILE   *InputFile = fopen(Filename, "rb");
    if(InputFile == NULL)
        {
        sprintf(MsgBuf,
             "Can't open file '%s' for reading.", Filename);
        MessageBox(Parent, MsgBuf, "PassThru",
                                         MB_OK|MB_ICONSTOP);
        delete[] Buffer;
        return FALSE;
        }

    HANDLE Printer;
    if(!OpenPrinter(PrinterName, &Printer, NULL))
        {
        wsprintf(MsgBuf, "OpenPrinter for '%s' failed: %ld",
            PrinterName, GetLastError());
        MessageBox(NULL, MsgBuf, "", MB_OK);
        FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM
            |FORMAT_MESSAGE_IGNORE_INSERTS, NULL,
            GetLastError(), MAKELANGID(LANG_NEUTRAL,
            SUBLANG_NEUTRAL), MsgBuf, 128, NULL);
        MessageBox(NULL, MsgBuf, "", MB_OK);
        delete[] Buffer;
        fclose(InputFile);
        return FALSE;
        }
    // now we have a printer handle

    DOC_INFO_2 Info;
    memset(&Info, 0, sizeof(Info));
    Info.pDocName       = Filename;
    Info.pOutputFile    = Port;
    Info.pDatatype      = 0;
    Info.dwMode         = DI_CHANNEL_WRITE;
    if(!StartDocPrinter(Printer, 2, (LPBYTE)&Info))
        {
        wsprintf(MsgBuf, "StartDocPrinter on '%s' failed: %ld",
            Port, GetLastError());
        MessageBox(NULL, MsgBuf, "", MB_OK);
        FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM
            |FORMAT_MESSAGE_IGNORE_INSERTS, NULL,
            GetLastError(), MAKELANGID(LANG_NEUTRAL,
            SUBLANG_NEUTRAL), MsgBuf, 128, NULL);
        MessageBox(NULL, MsgBuf, "", MB_OK);
        delete[] Buffer;
        fclose(InputFile);
        return FALSE;
        }

    // now we can start writing data

    HCURSOR OldCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
    size_t NBytes = 0;
    for(;;)
        {
        DWORD   Written;
        NBytes  = fread(Buffer, 1, BUFFER_SIZE, InputFile);
        if(NBytes > 0)
            WritePrinter(Printer, Buffer, NBytes, &Written);
        else
            break;
        }
    SetCursor(OldCursor);
    EndDocPrinter(Printer);
    ClosePrinter(Printer);
    fclose(InputFile);
    delete Buffer;
    return TRUE;
    }
