// devchg.c

#include <windows.h>
#include <dbt.h>
#include <pbt.h>
#include "devchg.h"

#define DBT_DEVTYP_PAULAT	0x80000111

typedef struct tagMY_USERDEFINED_INFO {
   struct _DEV_BROADCAST_HDR DBHdr; 
   char  szName[32];
   //BYTE  UserDefined[USER_LENGTH];
} MY_USERDEFINED_INFO;

MY_USERDEFINED_INFO  Info;

/**-----------------------------------------------------**/
int APIENTRY WinMain(HINSTANCE hInstance, 
   HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
   return DialogBox(hInstance, MAKEINTRESOURCE(DLG_DEVCHG),
      NULL, DevChgDlgProc); 
} // WinMain

/**-----------------------------------------------------**/
LRESULT CALLBACK DevChgDlgProc(HWND hDlg, UINT uMsg,
   WPARAM wParam, LPARAM lParam)
{
   switch (uMsg) {
      case WM_DEVICECHANGE:
         return ShowDeviceChange(hDlg, lParam, wParam);

      case WM_DISPLAYCHANGE:
         return ShowDisplayChange(hDlg, lParam, wParam);

      case WM_POWERBROADCAST:
         return ShowPowerChange(hDlg, lParam, wParam);

      case WM_COMMAND:
         switch(LOWORD(wParam)) {
            case ID_BT_BROADCAST: {
               DWORD dwRecipients = BSM_APPLICATIONS;
               Info.DBHdr.dbch_devicetype = DBT_DEVTYP_PAULAT;
               Info.DBHdr.dbch_size = sizeof(MY_USERDEFINED_INFO);
               lstrcpy(Info.szName, TEXT("PaulaT\\SomeData"));
               BroadcastSystemMessage(0, &dwRecipients, 
                  WM_DEVICECHANGE, DBT_USERDEFINED, 
                  (LPARAM)&Info);
            } break;

            case ID_BT_SUSPEND:
               SetSystemPowerState(TRUE, FALSE);
               break;

            case IDOK:
               EndDialog(hDlg, TRUE);
               return TRUE;

            default:
               break;
         }
   }
   return FALSE;
} // DevChangeDlgProc

//------------------------------------------------------------
int ShowDeviceChange(HWND hDlg, LPARAM lParam, WPARAM wParam)
{
   TCHAR                szMsg[256],szEvent[256];
   PDEV_BROADCAST_HDR   pHeader;
   MY_USERDEFINED_INFO *pUser;
   int                  Status = TRUE;

   lstrcpy(szMsg, TEXT("WM_DEVICECHANGE"));

   switch (wParam) {
      case DBT_DEVICEARRIVAL:        // device inserted
         lstrcat(szMsg, TEXT(", DBT_DEVICEARRIVAL"));
         Status = GetEventData(lParam, szEvent);
         break;
      
      case DBT_DEVICEQUERYREMOVE:    // okay to remove device?
         lstrcat(szMsg, TEXT(", DBT_DEVICEQUERYREMOVE"));
         Status = GetEventData(lParam, szEvent);
         break;

      case DBT_DEVICEQUERYREMOVEFAILED: // remove was vetoed
         lstrcat(szMsg, TEXT(", DBT_DEVICEQUERYREMOVEFAILED"));
         Status = GetEventData(lParam, szEvent);
         break;

      case DBT_DEVICEREMOVEPENDING:  // device about to remove
         lstrcat(szMsg, TEXT(", DBT_DEVICEREMOVEPENDING"));
         Status = GetEventData(lParam, szEvent);
         break;

      case DBT_DEVICEREMOVECOMPLETE: //	device removed
         lstrcat(szMsg, TEXT(", DBT_DEVICEREMOVECOMPLETE"));
         Status = GetEventData(lParam, szEvent);
         break;

      case DBT_DEVICETYPESPECIFIC:   // device-specific event
         lstrcat(szMsg, TEXT(", DBT_DEVICETYPESPECIFIC"));
         wsprintf(szEvent, TEXT(", lParam=%d"), lParam);
         break;

      case DBT_USERDEFINED:          // user defined event
         lstrcat(szMsg, TEXT(", DBT_USERDEFINED"));
         lstrcpy(szEvent, TEXT(", Unknown"));
         if (lParam != 0) {
           pHeader = (PDEV_BROADCAST_HDR)lParam;
           if (pHeader->dbch_devicetype == DBT_DEVTYP_PAULAT) {
              pUser = (MY_USERDEFINED_INFO *)lParam;
              wsprintf(szEvent, TEXT(", %s"), pUser->szName);
           }
         } 
         break;

      case DBT_CONFIGCHANGED:        // configuration changed
         lstrcat(szMsg, TEXT(", DBT_CONFIGCHANGED"));
         wsprintf(szEvent, TEXT(", lParam=%d"), lParam);
         break;

      case DBT_QUERYCHANGECONFIG:    // okay to change config?
         lstrcat(szMsg, TEXT(", DBT_QUERYCHANGECONFIG"));
         wsprintf(szEvent, TEXT(", lParam=%d"), lParam);
         break;
 
      case DBT_CONFIGCHANGECANCELED:  // config change vetoed
         lstrcat(szMsg, TEXT(", DBT_CONFIGCHANGECANCELED"));
         wsprintf(szEvent, TEXT(", lParam=%d"), lParam);
         break;

      default:
         lstrcat(szMsg, TEXT(", Unknown Event"));
         wsprintf(szEvent, TEXT(", lParam=%d"), lParam);
         break;
   }
   lstrcat(szMsg, szEvent);

   SendDlgItemMessage(hDlg, ID_LB_SYSMSGS, LB_ADDSTRING, 0, 
      (LPARAM)(LPTSTR)szMsg);
   return Status;
} // ShowDeviceChange

//------------------------------------------------------------
int GetEventData(LPARAM lParam, LPTSTR pszString)
{
   int Status = TRUE;
   PDEV_BROADCAST_HDR    pHeader;
   PDEV_BROADCAST_OEM    pOemData;
   PDEV_BROADCAST_VOLUME pVolumeData;
   PDEV_BROADCAST_PORT   pPortData;
   ULONG                 i, ulMask;
   TCHAR                 szVolume[128];

   if (lParam == 0) {
      lstrcpy(pszString, TEXT(", lParam = 0"));
      return Status;
   }

   pHeader = (PDEV_BROADCAST_HDR)lParam;

   switch (pHeader->dbch_devicetype) {
      case DBT_DEVTYP_OEM:    // OEM-defined device type
         pOemData = (PDEV_BROADCAST_OEM)pHeader;
         wsprintf(pszString, TEXT(", DBT_DEVTYP_OEM, id = %d"),
               pOemData->dbco_identifier);
         break;

      case DBT_DEVTYP_VOLUME: // logical volume
         pVolumeData = (PDEV_BROADCAST_VOLUME)pHeader;
         lstrcpy(pszString, TEXT(", DBT_DEVTYPE_VOLUME "));
         if (pVolumeData->dbcv_flags & DBTF_MEDIA)
            lstrcat(pszString, TEXT(" Media"));
         if (pVolumeData->dbcv_flags & DBTF_NET)
            lstrcat(pszString, TEXT(" Net"));

         ulMask = 1;
         for (i=0; i < 32; i++) {
         if (ulMask & pVolumeData->dbcv_unitmask) {
            wsprintf(szVolume, TEXT(", %c:"), 'A' + i);
            lstrcat(pszString, szVolume);
         }
         ulMask = ulMask << 1;
      }
      break;

      case DBT_DEVTYP_PORT:   // serial or parallel port
         pPortData = (PDEV_BROADCAST_PORT)pHeader;
         wsprintf(pszString, TEXT(", DBT_DEVTYPE_PORT, %s"),
               pPortData->dbcp_name);
         break;

      default:
         wsprintf(pszString, TEXT(", Unkown Type (%xh)"), 
               pHeader->dbch_devicetype);
         break;
   }
   return Status;
} // GetEventData

//------------------------------------------------------------
int ShowDisplayChange(HWND hDlg, LPARAM lParam, WPARAM wParam)
{
   TCHAR szMsg[MAX_PATH];

   wsprintf(szMsg, TEXT("WM_DISPLAYCHANGE, %d x %d, %d bits"),
         LOWORD(lParam), HIWORD(lParam), wParam);
   SendDlgItemMessage(hDlg, ID_LB_SYSMSGS, LB_ADDSTRING, 0, 
         (LPARAM)(LPTSTR)szMsg);
   return TRUE;
} // ShowDisplayChange

//------------------------------------------------------------
int ShowPowerChange(HWND hDlg, LPARAM lParam, WPARAM wParam)
{
   TCHAR szMsg[MAX_PATH];

   lstrcpy(szMsg, TEXT("WM_POWERBROADCAST"));
   
   switch(wParam) {
      case PBT_APMQUERYSUSPEND: // lParam == 0;
         lstrcat(szMsg, TEXT(", PBT_APMQUERYSUSPEND"));
         break;

      case PBT_APMQUERYSUSPENDFAILED:
         lstrcat(szMsg, TEXT(", PBT_APMQUERYSUSPENDFAILED"));
         if (lParam & 0x1) 
            lstrcat(szMsg, TEXT(", OK to prompt user"));
         break;

      case PBT_APMSUSPEND:
         lstrcat(szMsg, TEXT(", PBT_APMSUSPEND"));
         break;

      case PBT_APMRESUMESUSPEND:
         lstrcat(szMsg, TEXT(", PBT_APMRESUMESUSPEND"));
         break;

      default:
         lstrcat(szMsg, TEXT(", Unknown event"));
         break;
   }
   SendDlgItemMessage(hDlg, ID_LB_SYSMSGS, LB_ADDSTRING, 0, 
         (LPARAM)(LPTSTR)szMsg);
   return TRUE;
} // ShowPowerChange
